/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.monitoring;

import com.devexperts.qd.monitoring.SumDeltaCounter;
import com.devexperts.qd.stats.QDStats;
import java.util.Arrays;

class DeltaCounter {
    private static final long[] EMPTY = new long[0];
    private long oldValue;
    private long newValue;
    private long[] oldValues = EMPTY;
    private long[] newValues = EMPTY;

    DeltaCounter() {
    }

    public synchronized void collect(QDStats stats, QDStats.SValue statValue) {
        int count;
        if (statValue.isRid() && (count = stats.getRidCount()) > 0) {
            if (this.oldValues.length < count) {
                this.oldValues = Arrays.copyOfRange(this.oldValues, 0, count);
                this.newValues = Arrays.copyOfRange(this.newValues, 0, count);
            }
            System.arraycopy(this.newValues, 0, this.oldValues, 0, count);
            Arrays.fill(this.newValues, 0L);
            stats.addValues(statValue, false, this.newValues);
        }
        this.oldValue = this.newValue;
        this.newValue = stats.getValue(statValue);
    }

    public synchronized void aggregate(SumDeltaCounter sumCounter) {
        if (sumCounter.statValue.isRid()) {
            int count = Math.min(this.oldValues.length, sumCounter.recordDelta.length);
            for (int i = 0; i < count; ++i) {
                int n = i;
                sumCounter.recordDelta[n] = sumCounter.recordDelta[n] + (this.newValues[i] - this.oldValues[i]);
            }
        }
        sumCounter.totalDelta += this.newValue - this.oldValue;
    }
}

