/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rtapibldr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class RtApiBuilderMain {
    private static final String CLASS_SUFFIX = ".class";
    private final File srcDir;
    private final File destDir;

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Usage: java " + RtApiBuilderMain.class.getName() + " <src-dir> <dest-dir>");
            return;
        }
        File srcDir = new File(args[0]);
        File destDir = new File(args[1]);
        new RtApiBuilderMain(srcDir, destDir).scan("");
    }

    private RtApiBuilderMain(File srcDir, File destDir) {
        this.srcDir = srcDir;
        this.destDir = destDir;
    }

    private void scan(String path) throws IOException {
        File scanDir = new File(this.srcDir, path);
        System.out.println("Scanning " + scanDir);
        File[] files = scanDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String name = file.getName();
            if (file.isDirectory()) {
                this.scan(path + name + File.separator);
                continue;
            }
            if (!name.endsWith(CLASS_SUFFIX)) continue;
            this.processFile(file, path + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(File srcFile, String path) throws IOException {
        System.out.println("Processing " + srcFile);
        ClassWriter cv = new ClassWriter(0);
        SnipClassVisitor visitor = new SnipClassVisitor((ClassVisitor)cv);
        try (FileInputStream in = new FileInputStream(srcFile);){
            ClassReader cr = new ClassReader((InputStream)in);
            cr.accept((ClassVisitor)visitor, 7);
        }
        if (visitor.writeClass) {
            File destFile = new File(this.destDir, path);
            destFile.getParentFile().mkdirs();
            System.out.println("Writing " + destFile);
            try (FileOutputStream out = new FileOutputStream(destFile);){
                ((OutputStream)out).write(cv.toByteArray());
            }
        }
    }

    private static class SnipClassVisitor
    extends ClassAdapter {
        boolean writeClass;

        SnipClassVisitor(ClassVisitor cv) {
            super(cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.writeClass = (access & 1) != 0 || (access & 0x10) == 0;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if ((access & 5) == 0) {
                return null;
            }
            return super.visitField(access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ((access & 5) == 0) {
                return null;
            }
            if ((access & 0x400) == 0) {
                access |= 0x100;
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

