package com.dxfeed.acs.sample;

import com.devexperts.util.TimeUtil;
import com.devexperts.util.Timing;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedTimeSeriesSubscription;
import com.dxfeed.event.candle.Candle;
import com.dxfeed.event.candle.CandlePeriod;
import com.dxfeed.event.candle.CandleSymbol;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SpreadSymbolSubscriptionSample {

    private SpreadSymbolSubscriptionSample() {
    }

    public static void main(String[] args) throws InterruptedException {
        if (args.length < 2) {
            System.out.println("Usage: 'java -cp acs-api\\lib\\* com.dxfeed.acs.sample.SpreadSymbolSubscriptionSample " +
                "<endpointAddress> <symbol>'");
            System.out.println("	<address> - endpoint address");
            System.out.println("	<symbol>  - symbol to request");
            System.exit(0);
        }
        String endpointAddress = args[0];
        String symbol = args[1];
        if (symbol == null || !symbol.startsWith("=")) {
            System.out.println("Incorrect symbol: " + symbol +". Symbol shall start with '=', exiting...");
            System.exit(-1);
        }
        DXEndpoint endpoint = DXEndpoint.create().connect(endpointAddress);
        DXFeed feed = endpoint.getFeed();
        CountDownLatch eventLatch = new CountDownLatch(1);
        long fromTime = Timing.GMT.today().day_start - 10 * TimeUtil.DAY;
        CandleSymbol candleSymbol = CandleSymbol.valueOf(
            symbol,
            CandlePeriod.DAY // specify time based candle period
        );
        DXFeedTimeSeriesSubscription<Candle> sub = feed.createTimeSeriesSubscription(Candle.class);
        sub.addEventListener(events -> {
            System.out.println("Received: " + events);
            eventLatch.countDown();
        });
        sub.setFromTime(fromTime);
        sub.setSymbols(candleSymbol);
        eventLatch.await(5, TimeUnit.SECONDS);
    }
}
