package com.dxfeed.acs.sample;

import com.devexperts.rmi.RMIEndpoint;
import com.devexperts.util.TimeUtil;
import com.dxfeed.acs.TickService;
import com.dxfeed.event.market.TimeAndSale;
import com.dxfeed.promise.Promise;

import java.util.List;

public class TicksPromiseSample {

    private TicksPromiseSample() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: 'java -cp acs-api\\lib\\* com.dxfeed.acs.sample.TicksPromiseSample " +
                "<apiAddress> <symbol>'");
            System.out.println("	<apiAddress> - API RMI address");
            System.out.println("	<symbol>  - symbol to request");
            System.exit(0);
        }
        String apiAddress = args[0];
        String symbol = args[1];
        RMIEndpoint newEndpoint = RMIEndpoint.createEndpoint(RMIEndpoint.Side.CLIENT);
        newEndpoint.connect(apiAddress);
        TickService tickService = newEndpoint.getClient().getProxy(TickService.class);
        // new API may process events faster than old one
        long toTime = System.currentTimeMillis() - TimeUtil.MINUTE;
        long startTime = System.currentTimeMillis();
        long period = 10 * TimeUtil.MINUTE;
        Promise<List<TimeAndSale>> promise = tickService.getTicksPromise(symbol, toTime - period, toTime);
        processTicksPromise(startTime, promise);
        newEndpoint.close();
    }

    protected static void processTicksPromise(long startTime, Promise<List<TimeAndSale>> promise) {
        List<TimeAndSale> ticks = promise.await();
        System.out.println("Request has taken " + (System.currentTimeMillis() - startTime));
        System.out.printf("Received %d ticks, last = %s%n", ticks.size(), ticks.isEmpty() ? "none" : ticks.get(ticks.size() - 1));
    }
}
