package com.dxfeed.acs.sample;

import com.devexperts.rmi.RMIEndpoint;
import com.devexperts.util.TimeFormat;
import com.dxfeed.acs.CandleService;
import com.dxfeed.event.candle.Candle;
import com.dxfeed.event.candle.CandleSymbol;

import java.util.Collections;
import java.util.List;

/**
 * Sample class to demonstrate requesting candles via {@link CandleService}.
 */
public class SampleCandleServiceClient {

    private SampleCandleServiceClient() {
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: 'java -cp acs-api\\lib\\* com.dxfeed.acs.sample.SampleCandleServiceClient <address> <symbol> <from> <to>'");
            System.out.println("	<address>  - chart server RMI address");
            System.out.println("	<symbol>   - symbol to retrieve, for example 'AAPL{=d}'");
            System.out.println("	<from>     - datetime in yyyymmdd-hhmmss[+|-]zzzz format");
            System.out.println("	<to>       - datetime in yyyymmdd-hhmmss[+|-]zzzz format");
            System.exit(0);
        }
        String address = args[0];
        CandleSymbol candleSymbol = CandleSymbol.valueOf(args[1]);
        long from = TimeFormat.GMT.parse(args[2]).getTime();
        long to = TimeFormat.GMT.parse(args[3]).getTime();
        RMIEndpoint endpoint = RMIEndpoint.createEndpoint(RMIEndpoint.Side.CLIENT);
        endpoint.connect(address);
        CandleService candleService = endpoint.getClient().getProxy(CandleService.class);

        // snapshot mode with event flags
        List<Candle> candles = candleService.getCandles(candleSymbol, from, to);
        System.out.printf("[getCandles] Received %d candles: %s%n", candles.size(), candles);
        // candles without event flags
        List<Candle> plainCandles = candleService.getPlainCandles(Collections.singletonList(candleSymbol), from, to);
        System.out.printf("[getPlainCandles] Received %d candles: %s%n", plainCandles.size(), plainCandles);

        endpoint.close();
    }
}
