/*
 * !++
 * QDS - Quick Data Signalling Library
 * !-
 * Copyright (C) 2002 - 2024 Devexperts LLC
 * !-
 * This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
 * If a copy of the MPL was not distributed with this file, You can obtain one at
 * http://mozilla.org/MPL/2.0/.
 * !__
 */
package com.dxfeed.api.experimental.model;

import com.dxfeed.event.market.OrderBase;

import java.util.List;

@FunctionalInterface
public interface MarketDepthListener<E extends OrderBase> {
    class OrderBook<E> {
        private final List<E> buyOrders;
        private final List<E> sellOrders;

        OrderBook(List<E> buyOrders, List<E> sellOrders) {
            this.buyOrders = buyOrders;
            this.sellOrders = sellOrders;
        }

        public List<E> getBuyOrders() {
            return buyOrders;
        }

        public List<E> getSellOrders() {
            return sellOrders;
        }
    }

    void modelChanged(OrderBook<E> book);
}
