/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.experimental.model;

import com.dxfeed.api.experimental.model.AbstractTxModel;
import com.dxfeed.api.osub.IndexedEventSubscriptionSymbol;
import com.dxfeed.event.IndexedEvent;
import com.dxfeed.event.IndexedEventSource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class IndexedTxModel<E extends IndexedEvent<?>>
extends AbstractTxModel<E> {
    private Set<IndexedEventSource> sources;

    private IndexedTxModel(Builder<E> builder) {
        super(builder);
        this.sources = new HashSet<IndexedEventSource>(((Builder)builder).sources);
        this.updateSubscription(this.getUndecoratedSymbol(), this.sources);
    }

    public static <E extends IndexedEvent<?>> Builder<E> newBuilder(Class<E> eventType) {
        return new Builder<E>(eventType);
    }

    public synchronized Set<IndexedEventSource> getSources() {
        return this.sources.isEmpty() ? Collections.emptySet() : new HashSet<IndexedEventSource>(this.sources);
    }

    public synchronized void setSources(IndexedEventSource ... sources) {
        this.setSources(new HashSet<IndexedEventSource>(Arrays.asList(sources)));
    }

    public synchronized void setSources(Set<? extends IndexedEventSource> sources) {
        if (this.sources.equals(sources)) {
            return;
        }
        this.sources = new HashSet<IndexedEventSource>(sources);
        this.updateSubscription(this.getUndecoratedSymbol(), this.sources);
    }

    private void updateSubscription(Object symbol, Set<? extends IndexedEventSource> sources) {
        this.setSymbols(this.decorateSymbol(symbol, sources));
    }

    private Set<Object> decorateSymbol(Object symbol, Set<? extends IndexedEventSource> sources) {
        if (symbol == null) {
            return Collections.emptySet();
        }
        if (sources.isEmpty()) {
            return Collections.singleton(symbol);
        }
        HashSet<Object> symbols = new HashSet<Object>();
        for (IndexedEventSource indexedEventSource : sources) {
            symbols.add(new IndexedEventSubscriptionSymbol(symbol, indexedEventSource));
        }
        return symbols;
    }

    public static final class Builder<E extends IndexedEvent<?>>
    extends AbstractTxModel.Builder<E, Builder<E>> {
        private Set<IndexedEventSource> sources = new HashSet<IndexedEventSource>();

        public Builder(Class<E> eventType) {
            super(eventType);
        }

        public Builder<E> withSources(IndexedEventSource ... sources) {
            this.sources = new HashSet<IndexedEventSource>(Arrays.asList(sources));
            return this;
        }

        public Builder<E> withSources(Collection<? extends IndexedEventSource> sources) {
            this.sources = new HashSet<IndexedEventSource>(sources);
            return this;
        }

        @Override
        public IndexedTxModel<E> build() {
            return new IndexedTxModel(this);
        }
    }
}

