/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.experimental.model;

import com.devexperts.util.TimePeriod;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.experimental.model.TxEventProcessor;
import com.dxfeed.api.experimental.model.TxModelListener;
import com.dxfeed.event.IndexedEvent;
import com.dxfeed.event.IndexedEventSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

public abstract class AbstractTxModel<E extends IndexedEvent<?>>
implements AutoCloseable {
    private final Map<IndexedEventSource, TxEventProcessor<E>> processorsBySource = new HashMap<IndexedEventSource, TxEventProcessor<E>>();
    private final Set<TxEventProcessor<E>> readyProcessors = new LinkedHashSet<TxEventProcessor<E>>();
    private final DXFeedSubscription<E> subscription;
    private final Object undecoratedSymbol;
    protected final boolean isBatchProcessing;
    protected final boolean isSnapshotProcessing;
    protected final TxModelListener<E> listener;

    protected AbstractTxModel(Builder<E, ?> builder) {
        if (((Builder)builder).symbol == null) {
            throw new IllegalStateException("The 'symbol' must not be null.");
        }
        this.undecoratedSymbol = ((Builder)builder).symbol;
        this.isBatchProcessing = ((Builder)builder).isBatchProcessing;
        this.isSnapshotProcessing = ((Builder)builder).isSnapshotProcessing;
        this.subscription = new DXFeedSubscription(((Builder)builder).eventType);
        if (((Builder)builder).aggregationPeriod != null) {
            this.subscription.setAggregationPeriod(((Builder)builder).aggregationPeriod);
        }
        this.subscription.addEventListener(this::processEvents);
        this.subscription.setExecutor(((Builder)builder).executor);
        TxModelListener txModelListener = this.listener = ((Builder)builder).listener == null ? (source, events, isSnapshot) -> {} : ((Builder)builder).listener;
        if (((Builder)builder).feed != null) {
            this.subscription.attach(((Builder)builder).feed);
        }
    }

    public boolean isBatchProcessing() {
        return this.isBatchProcessing;
    }

    public boolean isSnapshotProcessing() {
        return this.isSnapshotProcessing;
    }

    public void attach(DXFeed feed) {
        this.subscription.attach(feed);
    }

    public void detach(DXFeed feed) {
        this.subscription.detach(feed);
    }

    public void setAggregationPeriod(TimePeriod aggregationPeriod) {
        this.subscription.setAggregationPeriod(aggregationPeriod);
    }

    @Override
    public void close() {
        this.subscription.close();
    }

    void processEvents(List<E> events) {
        for (IndexedEvent event : events) {
            TxEventProcessor processor = this.processorsBySource.computeIfAbsent(event.getSource(), this::createEventProcessor);
            if (!processor.processEvent(event)) continue;
            this.readyProcessors.add(processor);
        }
        this.readyProcessors.forEach(TxEventProcessor::receiveAllEventsInBatch);
        this.readyProcessors.clear();
    }

    TxEventProcessor<E> createEventProcessor(IndexedEventSource source) {
        return new TxEventProcessor(this.isBatchProcessing, this.isSnapshotProcessing, (transactions, isSnapshot) -> this.listener.eventsReceived(source, new ArrayList(transactions), isSnapshot));
    }

    protected Object getUndecoratedSymbol() {
        return this.undecoratedSymbol;
    }

    protected void setSymbols(Set<?> symbols) {
        this.subscription.setSymbols(symbols);
    }

    public static abstract class Builder<E extends IndexedEvent<?>, B extends Builder<E, B>> {
        private final Class<E> eventType;
        private boolean isBatchProcessing = true;
        private boolean isSnapshotProcessing;
        private DXFeed feed;
        private Object symbol;
        private TxModelListener<E> listener;
        private Executor executor;
        private TimePeriod aggregationPeriod;

        protected Builder(Class<E> eventType) {
            this.eventType = eventType;
        }

        public B withBatchProcessing(boolean isBatchProcessing) {
            this.isBatchProcessing = isBatchProcessing;
            return (B)this;
        }

        public B withSnapshotProcessing(boolean isSnapshotProcessing) {
            this.isSnapshotProcessing = isSnapshotProcessing;
            return (B)this;
        }

        public B withFeed(DXFeed feed) {
            this.feed = feed;
            return (B)this;
        }

        public B withAggregationPeriod(TimePeriod aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return (B)this;
        }

        public B withSymbol(Object symbol) {
            this.symbol = symbol;
            return (B)this;
        }

        public B withListener(TxModelListener<E> listener) {
            this.listener = listener;
            return (B)this;
        }

        public B withExecutor(Executor executor) {
            this.executor = executor;
            return (B)this;
        }

        public abstract AbstractTxModel<E> build();
    }
}

