/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.experimental.model;

import com.devexperts.qd.util.DxTimer;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.experimental.model.IndexedTxModel;
import com.dxfeed.api.experimental.model.MarketDepthListener;
import com.dxfeed.api.impl.DXFeedImpl;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderBase;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class MarketDepthModel<E extends OrderBase>
implements AutoCloseable {
    private static final Comparator<? super OrderBase> ORDER_COMPARATOR = (o1, o2) -> {
        boolean ind2;
        boolean ind1 = o1.getScope() == Scope.ORDER;
        boolean bl = ind2 = o2.getScope() == Scope.ORDER;
        if (ind1 && ind2) {
            int c = Long.compare(o1.getTimeSequence(), o2.getTimeSequence());
            if (c != 0) {
                return c;
            }
            c = Long.compare(o1.getIndex(), o2.getIndex());
            return c;
        }
        if (ind1) {
            return 1;
        }
        if (ind2) {
            return -1;
        }
        int c = Double.compare(o2.getSizeAsDouble(), o1.getSizeAsDouble());
        if (c != 0) {
            return c;
        }
        c = Long.compare(o1.getTimeSequence(), o2.getTimeSequence());
        if (c != 0) {
            return c;
        }
        c = o1.getScope().getCode() - o2.getScope().getCode();
        if (c != 0) {
            return c;
        }
        c = o1.getExchangeCode() - o2.getExchangeCode();
        if (c != 0) {
            return c;
        }
        if (o1 instanceof Order && o2 instanceof Order) {
            Order order1 = (Order)o1;
            Order order2 = (Order)o2;
            c = MarketDepthModel.compareString(order1.getMarketMaker(), order2.getMarketMaker());
            if (c != 0) {
                return c;
            }
        }
        c = Long.compare(o1.getIndex(), o2.getIndex());
        return c;
    };
    private static final Comparator<? super OrderBase> BUY_COMPARATOR = (o1, o2) -> o1.getPrice() < o2.getPrice() ? 1 : (o1.getPrice() > o2.getPrice() ? -1 : ORDER_COMPARATOR.compare((OrderBase)o1, (OrderBase)o2));
    private static final Comparator<? super OrderBase> SELL_COMPARATOR = (o1, o2) -> o1.getPrice() < o2.getPrice() ? -1 : (o1.getPrice() > o2.getPrice() ? 1 : ORDER_COMPARATOR.compare((OrderBase)o1, (OrderBase)o2));
    private final AtomicBoolean taskScheduled = new AtomicBoolean(false);
    private final Map<Long, E> ordersByIndex = new HashMap<Long, E>();
    private final OrderSet<E> buyOrders = new OrderSet(BUY_COMPARATOR);
    private final OrderSet<E> sellOrders = new OrderSet(SELL_COMPARATOR);
    private final IndexedTxModel<E> txModel;
    private final Executor executor;
    private DxTimer.Cancellable task;
    private MarketDepthListener<E> listener;
    private long aggregationPeriodMillis;
    private int depthLimit;

    private MarketDepthModel(Builder<E> builder) {
        this.depthLimit = ((Builder)builder).depthLimit;
        this.buyOrders.setDepthLimit(this.depthLimit);
        this.sellOrders.setDepthLimit(this.depthLimit);
        this.listener = ((Builder)builder).listener;
        this.executor = ((Builder)builder).executor != null ? ((Builder)builder).executor : ((DXFeedImpl)((Builder)builder).feed).getDXEndpoint().getOrCreateExecutor();
        this.aggregationPeriodMillis = ((Builder)builder).aggregationPeriodMillis;
        this.txModel = ((IndexedTxModel.Builder)((Builder)builder).txModelBuilder.withListener(this::eventsReceived)).build();
    }

    public static <E extends OrderBase> Builder<E> newBuilder(Class<E> eventType) {
        return new Builder<E>(eventType);
    }

    public void attachFeed(DXFeed feed) {
        this.txModel.attach(feed);
    }

    public void detachFeed(DXFeed feed) {
        this.txModel.detach(feed);
    }

    public synchronized int getDepthLimit() {
        return this.depthLimit;
    }

    public synchronized void setDepthLimit(int depthLimit) {
        if (depthLimit < 0) {
            depthLimit = 0;
        }
        if (this.depthLimit == depthLimit) {
            return;
        }
        this.depthLimit = depthLimit;
        this.buyOrders.setDepthLimit(depthLimit);
        this.sellOrders.setDepthLimit(depthLimit);
        this.tryCancelTask();
        this.notifyListeners();
    }

    public synchronized long getAggregationPeriod() {
        return this.aggregationPeriodMillis;
    }

    public synchronized void setAggregationPeriod(long aggregationPeriod, TimeUnit unit) {
        long aggregationPeriodMillis = unit.toMillis(aggregationPeriod);
        if (aggregationPeriodMillis < 0L) {
            aggregationPeriodMillis = 0L;
        }
        if (this.aggregationPeriodMillis == aggregationPeriodMillis) {
            return;
        }
        this.aggregationPeriodMillis = aggregationPeriodMillis;
        this.rescheduleTaskIfNeeded(aggregationPeriodMillis);
    }

    @Override
    public void close() {
        this.txModel.close();
        this.tryCancelTask();
        this.listener = null;
    }

    void processEvents(List<E> events) {
        this.txModel.processEvents(events);
    }

    private synchronized void eventsReceived(IndexedEventSource source, List<E> events, boolean isSnapshot) {
        if (this.update(source, events, isSnapshot)) {
            if (isSnapshot || this.aggregationPeriodMillis == 0L) {
                this.tryCancelTask();
                this.notifyListeners();
            } else {
                this.scheduleTaskIfNeeded(this.aggregationPeriodMillis);
            }
        }
    }

    private synchronized void notifyListeners() {
        try {
            MarketDepthListener<E> listener = this.listener;
            if (listener == null) {
                return;
            }
            listener.modelChanged(new MarketDepthListener.OrderBook<E>(this.getBuyOrders(), this.getSellOrders()));
        }
        finally {
            this.taskScheduled.set(false);
        }
    }

    private synchronized void scheduleTaskIfNeeded(long delayMillis) {
        if (this.taskScheduled.compareAndSet(false, true)) {
            this.task = DxTimer.getInstance().runOnce(() -> this.executor.execute(this::notifyListeners), delayMillis);
        }
    }

    private synchronized void rescheduleTaskIfNeeded(long delayMillis) {
        if (this.tryCancelTask() && delayMillis != 0L) {
            this.scheduleTaskIfNeeded(delayMillis);
        }
    }

    private synchronized boolean tryCancelTask() {
        if (this.taskScheduled.get() && this.task != null) {
            this.task.cancel();
            this.taskScheduled.set(false);
            return true;
        }
        return false;
    }

    private boolean update(IndexedEventSource source, List<E> events, boolean isSnapshot) {
        if (isSnapshot) {
            this.clearBySource(source);
        }
        for (OrderBase order : events) {
            OrderBase removed = (OrderBase)this.ordersByIndex.remove(order.getIndex());
            if (removed != null) {
                this.getOrderSetForOrder(removed).remove(removed);
            }
            if (!this.shallAdd(order)) continue;
            this.ordersByIndex.put(order.getIndex(), order);
            this.getOrderSetForOrder(order).add(order);
        }
        return this.isChanged();
    }

    private boolean isChanged() {
        return this.buyOrders.isChanged() || this.sellOrders.isChanged();
    }

    private List<E> getBuyOrders() {
        return this.buyOrders.toList();
    }

    private List<E> getSellOrders() {
        return this.sellOrders.toList();
    }

    private void clearBySource(IndexedEventSource source) {
        this.ordersByIndex.entrySet().removeIf(entry -> ((OrderBase)entry.getValue()).getSource().equals((Object)source));
        this.buyOrders.clearBySource(source);
        this.sellOrders.clearBySource(source);
    }

    private boolean shallAdd(E order) {
        return order.hasSize() && (order.getEventFlags() & 2) == 0;
    }

    private OrderSet<E> getOrderSetForOrder(E order) {
        return order.getOrderSide() == Side.BUY ? this.buyOrders : this.sellOrders;
    }

    private static int compareString(String s1, String s2) {
        return s1 != null ? (s2 != null ? s1.compareTo(s2) : 1) : (s2 != null ? -1 : 0);
    }

    private static class OrderSet<E extends OrderBase> {
        private final List<E> snapshot = new ArrayList();
        private final Comparator<? super OrderBase> comparator;
        private final TreeSet<E> orders;
        private int depthLimit;
        private boolean isChanged;

        public OrderSet(Comparator<? super OrderBase> comparator) {
            this.comparator = comparator;
            this.orders = new TreeSet<OrderBase>(comparator);
        }

        public void setDepthLimit(int depthLimit) {
            if (this.depthLimit == depthLimit) {
                return;
            }
            this.depthLimit = depthLimit;
            this.isChanged = true;
        }

        public void add(E order) {
            if (this.orders.add(order)) {
                this.markAsChangedIfNeeded(order);
            }
        }

        public void remove(E order) {
            if (this.orders.remove(order)) {
                this.markAsChangedIfNeeded(order);
            }
        }

        public boolean isChanged() {
            return this.isChanged;
        }

        public void clearBySource(IndexedEventSource source) {
            this.isChanged = this.orders.removeIf(order -> order.getSource().equals((Object)source));
        }

        public List<E> toList() {
            if (this.isChanged) {
                this.updateSnapshot();
            }
            return new ArrayList<E>(this.snapshot);
        }

        private void updateSnapshot() {
            this.isChanged = false;
            this.snapshot.clear();
            int limit = this.isDepthLimitUnbounded() ? Integer.MAX_VALUE : this.depthLimit;
            Iterator<E> it = this.orders.iterator();
            for (int i = 0; i < limit && it.hasNext(); ++i) {
                this.snapshot.add(it.next());
            }
        }

        private void markAsChangedIfNeeded(E order) {
            if (this.isChanged) {
                return;
            }
            if (this.isDepthLimitUnbounded() || this.isSizeWithinDepthLimit() || this.isOrderWithinDepthLimit(order)) {
                this.isChanged = true;
            }
        }

        private boolean isDepthLimitUnbounded() {
            return this.depthLimit <= 0 || this.depthLimit == Integer.MAX_VALUE;
        }

        private boolean isSizeWithinDepthLimit() {
            return this.orders.size() <= this.depthLimit;
        }

        private boolean isOrderWithinDepthLimit(E order) {
            if (this.snapshot.isEmpty()) {
                return true;
            }
            OrderBase last = (OrderBase)this.snapshot.get(this.snapshot.size() - 1);
            return this.comparator.compare((OrderBase)last, (OrderBase)order) >= 0;
        }
    }

    public static class Builder<E extends OrderBase> {
        private final IndexedTxModel.Builder<E> txModelBuilder;
        private DXFeed feed;
        private Executor executor;
        private MarketDepthListener<E> listener;
        private long aggregationPeriodMillis;
        private int depthLimit;

        public Builder(Class<E> eventType) {
            this.txModelBuilder = IndexedTxModel.newBuilder(eventType);
        }

        public Builder<E> withFeed(DXFeed feed) {
            this.txModelBuilder.withFeed(feed);
            this.feed = feed;
            return this;
        }

        public Builder<E> withSources(OrderSource ... sources) {
            this.txModelBuilder.withSources((IndexedEventSource[])sources);
            return this;
        }

        public Builder<E> withSources(Collection<OrderSource> sources) {
            this.txModelBuilder.withSources(sources);
            return this;
        }

        public Builder<E> withSymbol(String symbol) {
            this.txModelBuilder.withSymbol(symbol);
            return this;
        }

        public Builder<E> withExecutor(Executor executor) {
            this.txModelBuilder.withExecutor(executor);
            this.executor = executor;
            return this;
        }

        public Builder<E> withListener(MarketDepthListener<E> listener) {
            this.listener = listener;
            return this;
        }

        public Builder<E> withAggregationPeriod(int aggregationPeriod, TimeUnit unit) {
            long aggregationPeriodMillis = unit.toMillis(aggregationPeriod);
            if (aggregationPeriodMillis < 0L) {
                aggregationPeriodMillis = 0L;
            }
            this.aggregationPeriodMillis = aggregationPeriodMillis;
            return this;
        }

        public Builder<E> withDepthLimit(int depthLimit) {
            if (depthLimit < 0) {
                depthLimit = 0;
            }
            this.depthLimit = depthLimit;
            return this;
        }

        public MarketDepthModel<E> build() {
            return new MarketDepthModel(this);
        }
    }
}

