/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.experimental.model;

import com.dxfeed.api.experimental.model.AbstractTxModel;
import com.dxfeed.api.experimental.model.TxEventProcessor;
import com.dxfeed.api.osub.TimeSeriesSubscriptionSymbol;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.TimeSeriesEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public final class TimeSeriesTxModel<E extends TimeSeriesEvent<?>>
extends AbstractTxModel<E> {
    private final SortOrder sortOrder;
    private final boolean ignoreRemoveEvents;
    private final boolean ignoreEventsFromPast;
    private long fromTime;

    private TimeSeriesTxModel(Builder<E> builder) {
        super(builder);
        this.sortOrder = ((Builder)builder).sortOrder;
        this.fromTime = ((Builder)builder).fromTime;
        this.ignoreRemoveEvents = ((Builder)builder).ignoreRemoveEvents;
        this.ignoreEventsFromPast = ((Builder)builder).ignoreEventsFromPast;
        this.updateSubscription(this.getUndecoratedSymbol(), this.fromTime);
    }

    public static <E extends TimeSeriesEvent<?>> Builder<E> newBuilder(Class<E> eventType) {
        return new Builder<E>(eventType);
    }

    public synchronized long getFromTime() {
        return this.fromTime;
    }

    public synchronized void setFromTime(long fromTime) {
        if (this.fromTime == fromTime) {
            return;
        }
        this.fromTime = fromTime;
        this.setSymbols(this.decorateSymbol(this.getUndecoratedSymbol(), fromTime));
    }

    @Override
    TxEventProcessor<E> createEventProcessor(IndexedEventSource source) {
        return new TxEventProcessor(this.isBatchProcessing, this.isSnapshotProcessing, this.sortOrder, this.ignoreRemoveEvents, this.ignoreEventsFromPast, (transactions, isSnapshot) -> this.listener.eventsReceived(source, new ArrayList(transactions), isSnapshot));
    }

    private void updateSubscription(Object symbol, long fromTime) {
        this.setSymbols(this.decorateSymbol(symbol, fromTime));
    }

    private Set<Object> decorateSymbol(Object symbol, long fromTime) {
        if (symbol == null || fromTime == Long.MAX_VALUE) {
            return Collections.emptySet();
        }
        return Collections.singleton(new TimeSeriesSubscriptionSymbol(symbol, fromTime));
    }

    public static final class Builder<E extends TimeSeriesEvent<?>>
    extends AbstractTxModel.Builder<E, Builder<E>> {
        private long fromTime = Long.MAX_VALUE;
        private SortOrder sortOrder = SortOrder.NONE;
        private boolean ignoreRemoveEvents;
        private boolean ignoreEventsFromPast;

        public Builder(Class<E> eventType) {
            super(eventType);
        }

        public Builder<E> withFromTime(long fromTime) {
            this.fromTime = fromTime;
            return this;
        }

        public Builder<E> withSorting(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder<E> ignoreRemoveEvents(boolean ignoreRemoveEvents) {
            this.ignoreRemoveEvents = ignoreRemoveEvents;
            return this;
        }

        public Builder<E> ignoreEventsFromPast(boolean ignoreEventFromPast) {
            this.ignoreEventsFromPast = ignoreEventFromPast;
            return this;
        }

        @Override
        public TimeSeriesTxModel<E> build() {
            return new TimeSeriesTxModel(this);
        }
    }

    public static enum SortOrder {
        NONE,
        ASCENDING,
        DESCENDING;

    }
}

