/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api.experimental.model;

import com.dxfeed.api.experimental.model.TimeSeriesTxModel;
import com.dxfeed.event.IndexedEvent;
import com.dxfeed.event.market.OrderBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class TxEventProcessor<E extends IndexedEvent<?>> {
    private final List<E> pendingEvents = new ArrayList();
    private final TransactionProcessor<E> transactionProcessor;
    private final SnapshotProcessor<E> snapshotProcessor;
    private final boolean ignoreRemoveEvents;
    private final boolean ignoreEventsFromPast;
    private final TimeSeriesTxModel.SortOrder sortOrder;
    private boolean isPartialSnapshot;
    private boolean isCompleteSnapshot;
    private long lastIndex = Long.MIN_VALUE;

    public TxEventProcessor(boolean isBatchProcessing, boolean isSnapshotProcessing, TimeSeriesTxModel.SortOrder sortOrder, boolean ignoreRemoveEvents, boolean ignoreEventsFromPast, Listener<E> listener) {
        this.ignoreRemoveEvents = ignoreRemoveEvents;
        this.ignoreEventsFromPast = ignoreEventsFromPast;
        this.sortOrder = sortOrder;
        this.transactionProcessor = isBatchProcessing ? new BatchTransactionProcessor(listener) : new NotifyTransactionProcessor<E>(listener);
        this.snapshotProcessor = isSnapshotProcessing ? new ProcessingSnapshotProcessor(sortOrder, listener) : new NotifySnapshotProcessor<E>(listener);
    }

    public TxEventProcessor(boolean isBatchProcessing, boolean isSnapshotProcessing, Listener<E> listener) {
        this(isBatchProcessing, isSnapshotProcessing, TimeSeriesTxModel.SortOrder.NONE, false, false, listener);
    }

    public boolean processEvent(E event) {
        if (this.isSnapshotBegin(event)) {
            this.isPartialSnapshot = true;
            this.isCompleteSnapshot = false;
            this.lastIndex = Long.MIN_VALUE;
            this.pendingEvents.clear();
        }
        if (this.isPartialSnapshot && this.isSnapshotEndOrSnip(event)) {
            this.isPartialSnapshot = false;
            this.isCompleteSnapshot = true;
        }
        this.pendingEvents.add(event);
        if (this.isPending(event) || this.isPartialSnapshot) {
            return false;
        }
        if (this.isCompleteSnapshot) {
            this.snapshotProcessor.processSnapshot(this.pendingEvents);
            this.isCompleteSnapshot = false;
        } else {
            this.transactionProcessor.processTransaction(this.pendingEvents);
        }
        this.pendingEvents.clear();
        return true;
    }

    public void receiveAllEventsInBatch() {
        this.transactionProcessor.processingBatch();
    }

    private boolean isSnapshotBegin(E event) {
        return (event.getEventFlags() & 4) != 0;
    }

    private boolean isSnapshotEnd(E event) {
        return (event.getEventFlags() & 8) != 0;
    }

    private boolean isSnapshotSnip(E event) {
        return (event.getEventFlags() & 0x10) != 0;
    }

    private boolean isSnapshotEndOrSnip(E event) {
        return this.isSnapshotEnd(event) || this.isSnapshotSnip(event);
    }

    private boolean isPending(E event) {
        return (event.getEventFlags() & 1) != 0;
    }

    private boolean isRemove(E event) {
        return (event.getEventFlags() & 2) != 0;
    }

    private class ProcessingSnapshotProcessor
    implements SnapshotProcessor<E> {
        private final Listener<E> listener;
        private final Map<Long, E> snapshot;

        ProcessingSnapshotProcessor(TimeSeriesTxModel.SortOrder sortOrder, Listener<E> listener) {
            this.listener = listener;
            switch (sortOrder) {
                case NONE: {
                    this.snapshot = new LinkedHashMap();
                    break;
                }
                case ASCENDING: {
                    this.snapshot = new TreeMap(Comparator.naturalOrder());
                    break;
                }
                case DESCENDING: {
                    this.snapshot = new TreeMap(Comparator.reverseOrder());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown sort order: " + (Object)((Object)sortOrder));
                }
            }
        }

        @Override
        public void processSnapshot(List<E> events) {
            for (IndexedEvent event : events) {
                if (this.isRemove(event)) {
                    this.snapshot.remove(event.getIndex());
                    continue;
                }
                if (event.getIndex() > TxEventProcessor.this.lastIndex) {
                    TxEventProcessor.this.lastIndex = event.getIndex();
                }
                event.setEventFlags(0);
                this.snapshot.put(event.getIndex(), event);
            }
            this.listener.notify(this.snapshot.values(), true);
            this.snapshot.clear();
        }

        private boolean isRemove(E event) {
            if ((event.getEventFlags() & 2) != 0) {
                return true;
            }
            if (event instanceof OrderBase) {
                return !((OrderBase)event).hasSize();
            }
            return false;
        }
    }

    private static class NotifySnapshotProcessor<E extends IndexedEvent<?>>
    implements SnapshotProcessor<E> {
        private final Listener<E> listener;

        NotifySnapshotProcessor(Listener<E> listener) {
            this.listener = listener;
        }

        @Override
        public void processSnapshot(List<E> events) {
            this.listener.notify(events, true);
        }
    }

    private static interface SnapshotProcessor<E extends IndexedEvent<?>> {
        public void processSnapshot(List<E> var1);
    }

    private static class NotifyTransactionProcessor<E>
    implements TransactionProcessor<E> {
        private final Listener<E> listener;

        NotifyTransactionProcessor(Listener<E> listener) {
            this.listener = listener;
        }

        @Override
        public void processTransaction(List<E> events) {
            this.listener.notify(events, false);
        }

        @Override
        public void processingBatch() {
        }
    }

    private class BatchTransactionProcessor
    implements TransactionProcessor<E> {
        private final Listener<E> listener;
        private final List<E> transactions = new ArrayList();

        BatchTransactionProcessor(Listener<E> listener) {
            this.listener = listener;
        }

        @Override
        public void processTransaction(List<E> events) {
            this.transactions.addAll(events);
        }

        @Override
        public void processingBatch() {
            switch (TxEventProcessor.this.sortOrder) {
                case ASCENDING: {
                    this.transactions.sort(Comparator.comparingLong(IndexedEvent::getIndex));
                    break;
                }
                case DESCENDING: {
                    this.transactions.sort(Comparator.comparingLong(IndexedEvent::getIndex).reversed());
                }
            }
            Iterator it = this.transactions.iterator();
            while (it.hasNext()) {
                IndexedEvent event = (IndexedEvent)it.next();
                if (TxEventProcessor.this.ignoreRemoveEvents && TxEventProcessor.this.isRemove(event)) {
                    it.remove();
                    continue;
                }
                if (TxEventProcessor.this.ignoreEventsFromPast && event.getIndex() < TxEventProcessor.this.lastIndex) {
                    it.remove();
                    continue;
                }
                if (event.getIndex() <= TxEventProcessor.this.lastIndex) continue;
                TxEventProcessor.this.lastIndex = event.getIndex();
            }
            if (this.transactions.isEmpty()) {
                return;
            }
            this.listener.notify(this.transactions, false);
            this.transactions.clear();
        }
    }

    private static interface TransactionProcessor<E> {
        public void processTransaction(List<E> var1);

        public void processingBatch();
    }

    public static interface Listener<E> {
        public void notify(Collection<E> var1, boolean var2);
    }
}

