/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.dxlink.blackbox.core;

import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxErrorSink;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxInputStreamRequestProvider;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxOutputStreamErrorSink;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxOutputStreamResultSink;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxProbeRequest;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxProber;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxProberFactory;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxRequestProvider;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxResultSink;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DxLinkBlackbox {
    private static final Logger log = LoggerFactory.getLogger(DxLinkBlackbox.class);
    private static final DxLinkBlackboxRequestProvider REQUEST_PROVIDER = new DxLinkBlackboxInputStreamRequestProvider(System.in);
    private static final DxLinkBlackboxResultSink RESULT_SINK = new DxLinkBlackboxOutputStreamResultSink(System.out);
    private static final DxLinkBlackboxErrorSink ERROR_SINK = new DxLinkBlackboxOutputStreamErrorSink(System.out);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newVirtualThreadPerTaskExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(DxLinkBlackboxProberFactory factory) {
        DxLinkBlackboxProbeRequest lastRequest = null;
        try {
            while (true) {
                if ((lastRequest = REQUEST_PROVIDER.getProbeRequest()) == null) {
                    log.info("No more ProbeRequests. Exiting.");
                    break;
                }
                if (!lastRequest.isValid()) {
                    log.info("Failed to read ProbeRequest.");
                    continue;
                }
                DxLinkBlackboxProber prober = factory.createProbe(lastRequest);
                DxLinkBlackboxProbeRequest finalLastRequest = lastRequest;
                EXECUTOR_SERVICE.execute(() -> {
                    try {
                        RESULT_SINK.accept(finalLastRequest.requestId(), prober.probe());
                    }
                    catch (Exception e) {
                        log.error("Error while processing probe request: {}", (Object)finalLastRequest, (Object)e);
                        ERROR_SINK.accept(finalLastRequest.requestId(), e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("Error while running Prober Application", (Throwable)e);
            if (lastRequest != null) {
                ERROR_SINK.accept(lastRequest.requestId(), e.getMessage());
            }
        }
        finally {
            EXECUTOR_SERVICE.shutdown();
        }
    }
}

