/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.dxlink.blackbox.core;

import java.util.Map;

public record DxLinkBlackboxProbeRequest(int requestId, int timeLimit, Map<String, String> options) {
    private static final String TARGET_OPTION_KEY = "target";

    public String getTarget() {
        if (this.options.containsKey(TARGET_OPTION_KEY)) {
            return this.options.get(TARGET_OPTION_KEY);
        }
        throw new IllegalArgumentException("Target option is required");
    }

    public String getOption(String key) {
        return this.options.get(key);
    }

    public int getOption(String key, int defaultValue) {
        String value = this.options.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean isValid() {
        return this.options != null && !this.options.isEmpty() && this.requestId != -1 && this.timeLimit != -1;
    }
}

