/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.dxlink.blackbox.core;

import cloudprober.probes.external.CloudproberProbesExternal;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static byte[] readInputData(InputStream stream) throws IOException {
        int r;
        int contentLength;
        int curr;
        ByteArrayOutputStream headerBuf = new ByteArrayOutputStream();
        int prev = -1;
        while ((curr = stream.read()) != -1) {
            headerBuf.write(curr);
            if (prev == 10 && curr == 10) break;
            prev = curr;
        }
        if (headerBuf.size() == 0) {
            return null;
        }
        String headers = headerBuf.toString(StandardCharsets.UTF_8);
        int idx = headers.toLowerCase().indexOf("content-length:");
        if (idx == -1) {
            throw new IOException("Missing Content-Length header: " + headers);
        }
        int colonIdx = headers.indexOf(58, idx);
        int endIdx = headers.indexOf(10, colonIdx);
        if (endIdx == -1) {
            endIdx = headers.length();
        }
        String lenStr = headers.substring(colonIdx + 1, endIdx).trim();
        try {
            contentLength = Integer.parseInt(lenStr);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid Content-Length value: " + lenStr, e);
        }
        byte[] protobuf = new byte[contentLength];
        for (int read = 0; read < contentLength; read += r) {
            r = stream.read(protobuf, read, contentLength - read);
            if (r != -1) continue;
            throw new IOException("Unexpected EOF while reading protobuf payload (expected " + contentLength + " bytes, got " + read + ")");
        }
        return protobuf;
    }

    public static CloudproberProbesExternal.ProbeRequest parseProbeRequest(byte[] protobufData) {
        try {
            return CloudproberProbesExternal.ProbeRequest.parseFrom(protobufData);
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Protocol Buffer parsing failed: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static void sendProbeReply(CloudproberProbesExternal.ProbeReply reply, BufferedOutputStream stdout) throws IOException {
        byte[] replyBytes = reply.toByteArray();
        String httpHeaders = "Content-Length: " + replyBytes.length + "\n\n";
        stdout.write(httpHeaders.getBytes());
        stdout.write(replyBytes);
        stdout.flush();
    }
}

