/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.dxlink.blackbox.ws;

import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxProbeRequest;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxProbeResult;
import com.dxfeed.dxlink.blackbox.core.DxLinkBlackboxProber;
import com.dxfeed.dxlink.blackbox.core.metrics.DxLinkBlackboxMetric;
import com.dxfeed.dxlink.blackbox.core.metrics.DxLinkBlackboxMetricLabel;
import com.dxfeed.dxlink.blackbox.ws.DxLinkWsListener;
import com.dxfeed.dxlink.blackbox.ws.DxLinkWsMessage;
import com.google.gson.GsonBuilder;
import java.net.InetAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DxLinkWsProber
implements DxLinkBlackboxProber {
    private static final Logger log = LoggerFactory.getLogger(DxLinkWsProber.class);
    private static final int DEFAULT_WS_HANDSHAKE_TIMEOUT = 1000;
    private static final int DEFAULT_WS_SETUP_TIMEOUT = 60000;
    private static final int DEFAULT_AUTH_TIMEOUT = 60000;
    private static final String METRIC_PREFIX = "dxlink_ws_";
    private static final String DNS_LOOKUP_METRIC = "dxlink_ws_dns_lookup_latency_ms";
    private static final String HANDSHAKE_METRIC = "dxlink_ws_handshake_latency_ms";
    private static final String SETUP_ACK_METRIC = "dxlink_ws_setup_ack_latency_ms";
    private static final String AUTH_ACK_METRIC = "dxlink_ws_auth_latency_ms";
    private static final String WS_HANDSHAKE_TIMEOUT_KEY = "handshake_timeout";
    private static final String WS_SETUP_TIMEOUT_KEY = "setup_timeout";
    private static final String WS_AUTH_TIMEOUT_KEY = "auth_timeout";
    private static final String WS_AUTH_TOKEN_KEY = "auth_token";
    private static final String WS_AUTH_ENABLED_KEY = "auth_enabled";
    private static final String DNS_RESOLVE_TIMEOUT_KEY = "dns_resolve_timeout";
    private final DxLinkBlackboxProbeRequest request;
    private final List<DxLinkBlackboxMetric> metrics = new ArrayList<DxLinkBlackboxMetric>();
    private WebSocket webSocket;
    private final DxLinkWsListener wsListener;
    private final HttpClient httpClient;

    public DxLinkWsProber(DxLinkBlackboxProbeRequest request) {
        this.request = request;
        this.wsListener = new DxLinkWsListener();
        this.httpClient = HttpClient.newHttpClient();
    }

    DxLinkWsProber(DxLinkBlackboxProbeRequest request, DxLinkWsListener wsListener, HttpClient httpClient) {
        this.request = request;
        this.wsListener = wsListener != null ? wsListener : new DxLinkWsListener();
        this.httpClient = httpClient != null ? httpClient : HttpClient.newHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DxLinkBlackboxProbeResult probe() {
        try {
            double dnsLookupLatency = this.measureDnsLookupLatency();
            this.addMetric(new DxLinkBlackboxMetric(DNS_LOOKUP_METRIC, Double.valueOf(dnsLookupLatency), new DxLinkBlackboxMetricLabel[0]));
            double handshakeLatency = this.measureWebSocketHandshakeLatency();
            this.addMetric(new DxLinkBlackboxMetric(HANDSHAKE_METRIC, Double.valueOf(handshakeLatency), new DxLinkBlackboxMetricLabel[0]));
            double setupAckLatency = this.measureSetupAckLatency();
            this.addMetric(new DxLinkBlackboxMetric(SETUP_ACK_METRIC, Double.valueOf(setupAckLatency), new DxLinkBlackboxMetricLabel[0]));
            if (this.isAuthEnabled()) {
                double authAckLatency = this.measureAuthLatency();
                this.addMetric(new DxLinkBlackboxMetric(AUTH_ACK_METRIC, Double.valueOf(authAckLatency), new DxLinkBlackboxMetricLabel[0]));
            }
            DxLinkBlackboxProbeResult.Success success = new DxLinkBlackboxProbeResult.Success(this.metrics);
            return success;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            DxLinkBlackboxProbeResult.Error error = new DxLinkBlackboxProbeResult.Error(e.getMessage());
            return error;
        }
        finally {
            this.exitProbe();
        }
    }

    protected double measureDnsLookupLatency() throws Exception {
        long startTime = System.nanoTime();
        try {
            int dnsResolveTimeout = this.request.getOption(DNS_RESOLVE_TIMEOUT_KEY, this.request.timeLimit());
            CompletableFuture.runAsync(() -> {
                try {
                    URI uri = URI.create(this.request.getTarget());
                    InetAddress.getByName(uri.getHost());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).get(dnsResolveTimeout, TimeUnit.MILLISECONDS);
            return this.nanoToMillis(System.nanoTime() - startTime);
        }
        catch (Exception e) {
            throw new Exception("DNS lookup failed: " + e.getMessage());
        }
    }

    private double measureWebSocketHandshakeLatency() throws Exception {
        long startTime = System.nanoTime();
        int handshakeTimeout = this.request.getOption(WS_HANDSHAKE_TIMEOUT_KEY, 1000);
        try {
            this.webSocket = this.httpClient.newWebSocketBuilder().connectTimeout(Duration.ofMillis(handshakeTimeout)).buildAsync(URI.create(this.request.getTarget()), this.wsListener).join();
            long handshakeEndTime = this.wsListener.getHandshakeCompletedFuture().get();
            return this.nanoToMillis(handshakeEndTime - startTime);
        }
        catch (Exception e) {
            throw new Exception("WebSocket handshake failed: " + e.getMessage(), e);
        }
    }

    private double measureSetupAckLatency() throws Exception {
        try {
            int setupTimeout = this.request.getOption(WS_SETUP_TIMEOUT_KEY, 60000) / 1000;
            DxLinkWsMessage.Setup setupMessage = new DxLinkWsMessage.Setup("SETUP", 0, setupTimeout, setupTimeout, "1.0.0");
            String payload = new GsonBuilder().create().toJson((Object)setupMessage);
            long setupAckStartTime = System.nanoTime();
            this.getCurrentWsConnection().sendText(payload, true);
            long setupAckEndTime = this.wsListener.getAckReceivedFuture().get(setupTimeout, TimeUnit.SECONDS);
            return this.nanoToMillis(setupAckEndTime - setupAckStartTime);
        }
        catch (Exception e) {
            throw new Exception("SETUP message failed: " + e.getMessage(), e);
        }
    }

    private double measureAuthLatency() throws Exception {
        String authToken = this.request.getOption(WS_AUTH_TOKEN_KEY);
        if (authToken == null || authToken.isEmpty()) {
            throw new Exception("Auth token is not provided");
        }
        try {
            DxLinkWsMessage.Auth authMessage = new DxLinkWsMessage.Auth("AUTH", 0, authToken);
            String payload = new GsonBuilder().create().toJson((Object)authMessage);
            long authStartTime = System.nanoTime();
            this.getCurrentWsConnection().sendText(payload, true);
            int authTimeout = this.request.getOption(WS_AUTH_TIMEOUT_KEY, 60000);
            long authEndTime = this.wsListener.getAuthCompletedFuture().get(authTimeout, TimeUnit.MILLISECONDS);
            return this.nanoToMillis(authEndTime - authStartTime);
        }
        catch (Exception e) {
            throw new Exception("AUTH message failed: " + e.getMessage(), e);
        }
    }

    private WebSocket getCurrentWsConnection() throws Exception {
        if (this.webSocket != null && !this.webSocket.isOutputClosed()) {
            return this.webSocket;
        }
        throw new Exception("WebSocket is no longer open");
    }

    private boolean isAuthEnabled() {
        String authOption = this.request.getOption(WS_AUTH_ENABLED_KEY);
        return Boolean.parseBoolean(authOption);
    }

    private void exitProbe() {
        if (this.webSocket != null) {
            this.webSocket.sendClose(1000, "Probe completed").join();
        }
        this.httpClient.close();
    }

    private void addMetric(DxLinkBlackboxMetric metric) {
        this.metrics.add(metric);
    }

    private double nanoToMillis(long nanoTime) {
        return (double)nanoTime / 1000000.0;
    }
}

