package com.devexperts.mdd.news.event;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * Common news tags names.
 */
public class NewsTags {
    // Utility class only
    private NewsTags() {}

    // Consistent tool tags

    /** News id which was restoring from db*/
    public static final String NEWS_ID = "id";
    public static final String OLD_NEWS_SAVE_TIME = "saveTime";

    /** Reason why message can't be processed as normal. */
    public static final String UNPROCESS_REASON = "unprocessReason";

    // Required system tags

    /** Feed that generated the news. */
    public static final String NEWS_FEED = "feed";

    /** External ID assigned by news provider. */
    public static final String NEWS_SOURCE_ID = "sourceId";

    /** External ID of corrected news. */
    public static final String ORIGINAL_SOURCE_ID = "originalSourceId";
    /** News source provider prefix. */
    public static final String NEWS_SOURCE_PREFIX = "sourcePrefix";
    /** News source provider. */
    public static final String NEWS_SOURCE = "source";
    /** News origin url*/
    public static final String NEWS_SOURCE_URL = "url";

    /** News time (UTC millis as long value). */
    public static final String NEWS_TIME = "time";

    /** News title. */
    public static final String NEWS_TITLE = "title";

    /** News body (article) optional. */
    public static final String NEWS_BODY = "body";

    /** News correction original id optional. */
    public static final String ORIGINAL_ID = "originalId";

    /** News chainId (for the news chains) optional. */
    public static final String CHAIN_ID = "chainId";

    /** News action optional. */
    public static final String NEWS_ACTION = "action";

    /** News action reason optional. */
    public static final String ACTION_REASON = "reason";
    /** News action reason optional. */
    public static final String EXTRA_ATTRIBUTES = "extraAttributes";

    public static final Set<String> SYSTEM_TAGS;
    static {
        Set<String> tags = new HashSet<>();
        tags.add(NEWS_FEED);
        tags.add(NEWS_SOURCE);
        tags.add(NEWS_SOURCE_PREFIX);
        tags.add(NEWS_SOURCE_ID);
        tags.add(NEWS_TIME);
        tags.add(NEWS_TITLE);
        tags.add(NEWS_BODY);
        tags.add(ORIGINAL_ID);
        tags.add(CHAIN_ID);
        tags.add(NEWS_ACTION);
        tags.add(ACTION_REASON);
        tags.add(EXTRA_ATTRIBUTES);
        tags.add(ORIGINAL_SOURCE_ID);
        tags.add(UNPROCESS_REASON);
        tags.add(NEWS_SOURCE_URL);
        SYSTEM_TAGS = Collections.unmodifiableSet(tags);
    }

    // Public optional tags
    //FIXME Tags should be lower-case but remained as-is for backward compatibility

    /** Optional tag for stock symbols related to the news. */
    public static final String SYMBOLS = "Symbols";

    /** Optional tag for boolean flag for the 'hot' news. */
    public static final String HOT = "hot";

    public static final Set<String> OPTIONAL_TAGS;
    static {
        Set<String> tags = new HashSet<>();
        tags.add(SYMBOLS);
        tags.add(HOT);
        OPTIONAL_TAGS = Collections.unmodifiableSet(tags);
    }

    // Internal tags

    /** Internal tag for news raw data (as seen by the feed). */
    public static final String CONTENT_NEWS = "_news";

    /** Internal optional tag for news raw meta information (if available). */
    public static final String CONTENT_META = "_meta";
}
