/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mdd.news.model;

import com.devexperts.mdd.news.event.NewsEvent;
import com.dxfeed.model.ObservableListModel;
import com.dxfeed.model.ObservableListModelListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class ObservableNewsList
extends AbstractList<NewsEvent>
implements ObservableListModel<NewsEvent> {
    private static final Comparator<NewsEvent> REVERSE_COMPARATOR = Collections.reverseOrder();
    private final List<ObservableListModelListener<? super NewsEvent>> listeners = new CopyOnWriteArrayList<ObservableListModelListener<? super NewsEvent>>();
    private final ArrayList<NewsEvent> news = new ArrayList(100);
    private int limit;
    private boolean changed;

    ObservableNewsList() {
    }

    @Override
    public NewsEvent get(int index) {
        return this.news.get(index);
    }

    @Override
    public int size() {
        return this.news.size();
    }

    @Override
    public void clear() {
        this.changed = true;
        this.news.clear();
    }

    public void addListener(ObservableListModelListener<? super NewsEvent> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ObservableListModelListener<? super NewsEvent> listener) {
        this.listeners.remove(listener);
    }

    void setLimit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be positive: " + limit);
        }
        this.limit = limit;
        if (this.news.size() > limit) {
            while (this.news.size() > limit) {
                this.news.remove(this.news.size() - 1);
            }
            this.fireModelChanged();
        }
    }

    protected void beginChange() {
        this.changed = false;
    }

    protected boolean addChange(NewsEvent newsEvent) {
        if (newsEvent == null) {
            throw new NullPointerException("newsSummary");
        }
        int index = Collections.binarySearch(this.news, newsEvent, REVERSE_COMPARATOR);
        if (index >= 0) {
            return false;
        }
        this.news.add(-index - 1, newsEvent);
        while (this.news.size() > this.limit) {
            this.news.remove(this.news.size() - 1);
        }
        this.changed = true;
        return true;
    }

    protected void endChange() {
        if (this.changed) {
            this.fireModelChanged();
        }
    }

    protected void fireModelChanged() {
        ObservableListModelListener.Change change = new ObservableListModelListener.Change((ObservableListModel)this);
        for (ObservableListModelListener<? super NewsEvent> listener : this.listeners) {
            listener.modelChanged(change);
        }
    }
}

