package com.devexperts.mdd.news.event;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum ActionReason {
    BODY(Collections.singletonList(NewsTags.NEWS_BODY)),
    TITLE(Collections.singletonList(NewsTags.NEWS_TITLE)),
    EXTRA_ATTRIBUTES(Arrays.asList(NewsTags.SYMBOLS, NewsTags.EXTRA_ATTRIBUTES, NewsTags.CHAIN_ID, NewsTags.HOT)),
    PURGE(Collections.emptyList()),
    EXPIRATION(Collections.emptyList()),
    NOT_AVAILABLE(Collections.emptyList()),
    UNKNOWN(Collections.emptyList());

    private final Set<String> affectedTags;

    ActionReason(Collection<String> affectedTags) {
        this.affectedTags = Collections.unmodifiableSet(new HashSet<>(affectedTags));
    }

    public Set<String> getAffectedTags() {
        return affectedTags;
    }
}
