package com.devexperts.mdd.news.model;

import com.devexperts.mdd.news.event.NewsKey;

/**
 * The specified news does not exist in the repository.
 */
public class NewsNotFoundException extends RuntimeException {
    
    private final NewsKey newsKey;

    public NewsNotFoundException(NewsKey newsKey) {
        super("News not found: " + newsKey);
        this.newsKey = newsKey;
    }

    public NewsKey getNewsKey() {
        return newsKey;
    }
}
