/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mdd.news.event;

import com.devexperts.mdd.news.event.NewsEvent;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Pattern;

public final class NewsOrigin
implements Serializable {
    public static final NewsOrigin ANY = new NewsOrigin("*", "*", "*");
    public static final NewsOrigin NOTHING = new NewsOrigin();
    private final String feed;
    private final String sourcePrefix;
    private final String source;
    private static final Pattern FEED_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9]*$");

    public static NewsOrigin valueOf(String origin) {
        Objects.requireNonNull(origin, "origin");
        if (origin.isEmpty()) {
            return NOTHING;
        }
        String[] originParts = origin.split(":");
        String feed = originParts[0];
        String sourcePrefix = originParts.length == 3 ? originParts[1] : "*";
        String source = originParts.length > 1 ? originParts[originParts.length - 1] : "*";
        return NewsOrigin.valueOf(feed, sourcePrefix, source);
    }

    public static NewsOrigin valueOf(String feed, String sourcePrefix, String source) {
        NewsOrigin.checkFeedFormat(feed);
        Objects.requireNonNull(source, "source");
        if (sourcePrefix == null) {
            sourcePrefix = "";
        }
        if (feed.isEmpty() && source.isEmpty() && sourcePrefix.isEmpty()) {
            return NOTHING;
        }
        if (("*".equals(feed) || feed.isEmpty()) && ("*".equals(source) || source.isEmpty()) && "*".equals(sourcePrefix)) {
            return ANY;
        }
        return new NewsOrigin(feed.isEmpty() ? "*" : feed, sourcePrefix, source.isEmpty() ? "*" : source);
    }

    public static NewsOrigin valueOf(NewsEvent event) {
        Objects.requireNonNull(event, "event");
        return new NewsOrigin(event.getFeed(), event.getSourcePrefix(), event.getSource());
    }

    private NewsOrigin(String feed, String sourcePrefix, String source) {
        this.feed = feed;
        this.sourcePrefix = sourcePrefix;
        this.source = source;
    }

    private NewsOrigin() {
        this.feed = "";
        this.sourcePrefix = "";
        this.source = "";
    }

    public String getFeed() {
        return this.feed;
    }

    public String getSource() {
        return this.source;
    }

    public String getSourcePrefix() {
        return this.sourcePrefix;
    }

    public boolean isFeedWildcard() {
        return "*".equals(this.feed);
    }

    public boolean isSourceWildcard() {
        return "*".equals(this.source);
    }

    public boolean isSourcePrefixWildcard() {
        return "*".equals(this.sourcePrefix);
    }

    public boolean isWildcard() {
        return this.isFeedWildcard() && this.isSourceWildcard() && this.isSourcePrefixWildcard();
    }

    public boolean isExact() {
        return !this.isFeedWildcard() && !this.isSourceWildcard() && !this.feed.isEmpty() && !this.source.isEmpty() && (this.sourcePrefix == null || !this.isSourcePrefixWildcard());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewsOrigin that = (NewsOrigin)o;
        return Objects.equals(this.feed, that.feed) && Objects.equals(this.sourcePrefix, that.sourcePrefix) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.feed, this.sourcePrefix, this.source);
    }

    public String toString() {
        return this.feed.isEmpty() && this.source.isEmpty() && this.sourcePrefix.isEmpty() ? "" : this.feed + ":" + this.sourcePrefix + ":" + this.source;
    }

    private static void checkFeedFormat(String feed) {
        Objects.requireNonNull(feed, "feed");
        if (feed.isEmpty() || "*".equals(feed)) {
            return;
        }
        if (FEED_PATTERN.matcher(feed).matches()) {
            return;
        }
        throw new IllegalArgumentException("Invalid feed name \"" + feed + "\"");
    }

    public boolean isEmptySourcePrefix() {
        return this.sourcePrefix == null || this.sourcePrefix.isEmpty();
    }
}

