/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.orcs.qd;

import com.devexperts.io.IOUtil;
import com.devexperts.qd.util.Decimal;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.TimeSeriesEvent;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import com.dxfeed.orcs.qd.PriceLevelCandleType;
import com.dxfeed.orcs.qd.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@Deprecated
public class PriceLevelCandle
implements TimeSeriesEvent<CandleSymbol> {
    public static final int MAX_SEQUENCE = 0x3FFFFF;
    public static final int TYPE_MASK = 3;
    public static final int TYPE_SHIFT = 11;
    static final int EXCHANGE_MASK = 127;
    static final int EXCHANGE_SHIFT = 4;
    static final int SIDE_MASK = 3;
    static final int SIDE_SHIFT = 2;
    static final int SCOPE_MASK = 3;
    static final int SCOPE_SHIFT = 0;
    private CandleSymbol eventSymbol;
    private int eventFlags;
    private long eventTime;
    private long timeSequence;
    private long orderSourceAndIndex;
    private int timeNanoPart;
    private double price = Double.NaN;
    private long size;
    private long count;
    private int flags;
    private int bidSize;
    private int bidCount;
    private int askSize;
    private int askCount;
    private String marketMaker;

    public int getTimeNanoPart() {
        return this.timeNanoPart;
    }

    public void setTimeNanoPart(int timeNanoPart) {
        this.timeNanoPart = timeNanoPart;
    }

    public long getTimeSequence() {
        return this.timeSequence;
    }

    public void setTimeSequence(long timeSequence) {
        this.timeSequence = timeSequence;
    }

    public OrderSource getSource() {
        int sourceId = (int)(this.orderSourceAndIndex >> 48);
        if (!OrderSource.isSpecialSourceId((int)sourceId)) {
            sourceId = (int)(this.orderSourceAndIndex >> 32);
        }
        return OrderSource.valueOf((int)sourceId);
    }

    public long getOrderSourceAndIndex() {
        return this.orderSourceAndIndex;
    }

    public void setOrderSourceAndIndex(long orderSourceAndIndex) {
        this.orderSourceAndIndex = orderSourceAndIndex;
    }

    public int getEventFlags() {
        return this.eventFlags;
    }

    public void setEventFlags(int eventFlags) {
        this.eventFlags = eventFlags;
    }

    public long getIndex() {
        return this.getTimeSequence();
    }

    public void setIndex(long index) {
        this.timeSequence = index;
    }

    public long getTime() {
        return (this.timeSequence >> 32) * 1000L + (this.timeSequence >> 22 & 0x3FFL);
    }

    public void setTime(long time) {
        this.timeSequence = (long)TimeUtil.getSecondsFromTime((long)time) << 32 | (long)TimeUtil.getMillisFromTime((long)time) << 22 | (long)this.getSequence();
    }

    public int getSequence() {
        return (int)this.timeSequence & 0x3FFFFF;
    }

    public void setSequence(int sequence) {
        if (sequence < 0 || sequence > 0x3FFFFF) {
            throw new IllegalArgumentException();
        }
        this.timeSequence = this.timeSequence & 0xFFFFFFFFFFC00000L | (long)sequence;
    }

    public long getSize() {
        return this.askSize + this.bidSize;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getCount() {
        return this.askCount + this.bidCount;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getMarketMaker() {
        return this.marketMaker;
    }

    public void setMarketMaker(String marketMaker) {
        this.marketMaker = marketMaker;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public int getBidSize() {
        return this.bidSize;
    }

    public void setBidSize(int bidSize) {
        this.bidSize = bidSize;
    }

    public int getBidCount() {
        return this.bidCount;
    }

    public void setBidCount(int bidCount) {
        this.bidCount = bidCount;
    }

    public int getAskSize() {
        return this.askSize;
    }

    public void setAskSize(int askSize) {
        this.askSize = askSize;
    }

    public int getAskCount() {
        return this.askCount;
    }

    public void setAskCount(int askCount) {
        this.askCount = askCount;
    }

    public Side getSide() {
        return Side.valueOf((int)Util.getBits(this.flags, 3, 2));
    }

    public PriceLevelCandleType getType() {
        return PriceLevelCandleType.valueOf(Util.getBits(this.flags, 3, 11));
    }

    public CandleSymbol getEventSymbol() {
        return this.eventSymbol;
    }

    public void setEventSymbol(CandleSymbol eventSymbol) {
        this.eventSymbol = eventSymbol;
    }

    public Scope getScope() {
        return Scope.valueOf((int)Util.getBits(this.flags, 3, 0));
    }

    public String toString() {
        return "Order{" + this.getEventSymbol() + ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(this.getEventTime()) + ", source=" + this.getSource() + ", eventFlags=0x" + Integer.toHexString(this.getEventFlags()) + ", orderIndex=" + (int)this.orderSourceAndIndex + ", time=" + TimeFormat.DEFAULT.withMillis().format(this.getTime()) + ", sequence=" + this.getSequence() + ", timeNanoPart=" + this.timeNanoPart + ", price=" + this.price + ", size=" + this.size + ", count=" + this.count + ", bidSize=" + this.bidSize + ", bidCount=" + this.bidCount + ", askSize=" + this.askSize + ", askCount=" + this.askCount + ", side=" + this.getSide() + ", scope=" + this.getScope() + ", type=" + (Object)((Object)this.getType()) + ", marketMaker='" + this.marketMaker + "'}";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.eventSymbol);
        IOUtil.writeCompactLong((DataOutput)out, (long)this.timeSequence);
        IOUtil.writeCompactLong((DataOutput)out, (long)this.orderSourceAndIndex);
        IOUtil.writeCompactInt((DataOutput)out, (int)Decimal.compose((double)this.price));
        IOUtil.writeCompactInt((DataOutput)out, (int)this.bidSize);
        IOUtil.writeCompactInt((DataOutput)out, (int)this.bidCount);
        IOUtil.writeCompactInt((DataOutput)out, (int)this.askSize);
        IOUtil.writeCompactInt((DataOutput)out, (int)this.askCount);
        IOUtil.writeUTFString((DataOutput)out, (String)this.marketMaker);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.eventSymbol = (CandleSymbol)in.readObject();
        this.timeSequence = IOUtil.readCompactLong((DataInput)in);
        this.orderSourceAndIndex = IOUtil.readCompactLong((DataInput)in);
        this.price = Decimal.toDouble((int)IOUtil.readCompactInt((DataInput)in));
        this.bidSize = IOUtil.readCompactInt((DataInput)in);
        this.bidCount = IOUtil.readCompactInt((DataInput)in);
        this.askSize = IOUtil.readCompactInt((DataInput)in);
        this.askCount = IOUtil.readCompactInt((DataInput)in);
        this.size = this.askSize + this.bidSize;
        this.count = this.askCount + this.bidCount;
        this.marketMaker = IOUtil.readUTFString((DataInput)in);
    }
}

