package com.dxfeed.orcs.api;

import com.dxfeed.event.market.OrderSource;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * Represents information about available symbols to the client for the
 * entitled collection of {@link com.dxfeed.event.market.OrderSource}.
 */
public class AuthOrderSource implements Serializable {
    private static final long serialVersionUID = 0L;

    private final Map<Integer, Set<String>> symbolsByOrderSourceId;

    public static AuthOrderSource create(Map<Integer, Set<String>> symbolsByOrderSourceId) {
        return new AuthOrderSource(symbolsByOrderSourceId);
    }

    private AuthOrderSource(Map<Integer, Set<String>> symbolsByOrderSourceId) {
        this.symbolsByOrderSourceId = symbolsByOrderSourceId;
    }

    public Map<Integer, Set<String>> getByIds() {
        return symbolsByOrderSourceId;
    }

    public Map<OrderSource, Set<String>> getByOrderSources() {
        Map<OrderSource, Set<String>> result = new HashMap<>(symbolsByOrderSourceId.size());
        for (Map.Entry<Integer, Set<String>> entry : symbolsByOrderSourceId.entrySet()) {
            result.put(OrderSource.valueOf(entry.getKey()), entry.getValue());
        }
        return result;
    }
}
