/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.orcs;

import com.devexperts.rmi.RMIEndpoint;
import com.devexperts.util.TimeFormat;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Quote;
import com.dxfeed.orcs.PriceLevelChecker;
import com.dxfeed.orcs.api.AuthOrderSource;
import com.dxfeed.orcs.api.PriceLevelService;
import java.util.List;

public class SamplePriceLevelServiceClient {
    private SamplePriceLevelServiceClient() {
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("Usage: 'java -cp orcs-api\\lib\\* com.dxfeed.orcs.SamplePriceLevelServiceClient <address> <symbol> <source> <from> <to>");
            System.out.println("\t<address>  - server RMI address");
            System.out.println("\t<symbol>   - symbol to retrieve, for example 'AAPL{=d,gr=s}'");
            System.out.println("\t<source>   - source to retrieve, for example 'NTV'");
            System.out.println("\t<from>     - datetime in yyyymmdd-hhmmss[+|-]zzzz format");
            System.out.println("\t<to>       - datetime in yyyymmdd-hhmmss[+|-]zzzz format");
            System.exit(0);
        }
        String address = args[0];
        CandleSymbol candleSymbol = CandleSymbol.valueOf((String)args[1]);
        OrderSource source = OrderSource.valueOf((String)args[2]);
        long timeGapBound = 60000L;
        boolean printQuotes = true;
        RMIEndpoint endpoint = RMIEndpoint.createEndpoint((RMIEndpoint.Side)RMIEndpoint.Side.CLIENT);
        endpoint.connect(address);
        PriceLevelService service = (PriceLevelService)endpoint.getClient().getProxy(PriceLevelService.class);
        AuthOrderSource authOrderSource = service.getAuthOrderSource();
        System.out.println("Authorized sources: " + authOrderSource.getByOrderSources().keySet());
        long from = TimeFormat.GMT.parse(args[3]).getTime();
        long to = TimeFormat.GMT.parse(args[4]).getTime();
        long reqStart = System.currentTimeMillis();
        List<Order> orders = service.getOrders(candleSymbol, source.id(), from, to, "sample");
        System.out.println("Received " + orders.size() + " orders in " + (System.currentTimeMillis() - reqStart) + "ms");
        if (System.getProperty("validate") != null) {
            PriceLevelChecker.validate(orders, timeGapBound, printQuotes);
        }
        reqStart = System.currentTimeMillis();
        List<Quote> quotes = service.getQuotes(CandleSymbol.valueOf((String)(candleSymbol.getBaseSymbol() + "{gr=s}")), from, to, "sample");
        System.out.println("Received " + quotes.size() + " quotes in " + (System.currentTimeMillis() - reqStart) + "ms");
        endpoint.close();
    }
}

