package com.devexperts.mdd.vap;

import java.io.Serializable;
import java.util.Arrays;

public final class OptionStatisticsData implements Serializable {
    private static final long serialVersionUID = 1L;

    private final double _52wIVHigh;
    private final double _52wIVLow;
    private final double iv;
    private final double _52wHVHigh;
    private final double _52wHVLow;
    private final double hv;
    private final double putVolume;
    private final double callVolume;
    private final double putCallRatio;
    private final double vwap;
    private final double putBelowBidFrac;
    private final double putBetweenMarketFrac;
    private final double putOverAskFrac;
    private final double callBelowBidFrac;
    private final double callBetweenMarketFrac;
    private final double callOverAskFrac;
    private final double totalBelowBidFrac;
    private final double totalBetweenMarketFrac;
    private final double totalOverAskFrac;
    private final double[] perDeltaPut;
    private final double[] perDeltaCall;

    public OptionStatisticsData(double _52wIVHigh, double _52wIVLow, double iv, double _52wHVHigh, double _52wHVLow, double hv,
        double putVolume, double callVolume, double putCallRatio, double vwap, double putBelowBid, double putBetweenMarket,
        double putOverAsk, double callBelowBid, double callBetweenMarket, double callOverAsk, double[] perDeltaPut, double[] perDeltaCall)
    {
        this._52wIVHigh = _52wIVHigh;
        this._52wIVLow = _52wIVLow;
        this.iv = iv;
        this._52wHVHigh = _52wHVHigh;
        this._52wHVLow = _52wHVLow;
        this.hv = hv;
        this.putVolume = putVolume;
        this.callVolume = callVolume;
        this.putCallRatio = putCallRatio;
        this.vwap = vwap;

        double putTotal = putBelowBid + putBetweenMarket + putOverAsk;
        double callTotal = callBelowBid + callBetweenMarket + callOverAsk;
        double total = putTotal + callTotal;

        this.putBelowBidFrac = putTotal == 0 ? Double.NaN : putBelowBid / putTotal;
        this.putBetweenMarketFrac = putTotal == 0 ? Double.NaN : putBetweenMarket / putTotal;
        this.putOverAskFrac = putTotal == 0 ? Double.NaN : putOverAsk / putTotal;
        this.callBelowBidFrac = callTotal == 0 ? Double.NaN : callBelowBid / callTotal;
        this.callBetweenMarketFrac = callTotal == 0 ? Double.NaN : callBetweenMarket / callTotal;
        this.callOverAskFrac = callTotal == 0 ? Double.NaN : callOverAsk / callTotal;
        this.totalBelowBidFrac = total == 0 ? Double.NaN : (putBelowBid + callBelowBid) / total;
        this.totalBetweenMarketFrac = total == 0 ? Double.NaN : (putBetweenMarket + callBetweenMarket) / total;
        this.totalOverAskFrac = total == 0 ? Double.NaN : (putOverAsk + callOverAsk) / total;

        this.perDeltaPut = new double[perDeltaPut.length];
        for (int i = 0; i < perDeltaPut.length; i++) {
            this.perDeltaPut[i] = putTotal == 0 ? Double.NaN : perDeltaPut[i] / putTotal;
        }
        this.perDeltaCall = new double[perDeltaCall.length];
        for (int i = 0; i < perDeltaCall.length; i++) {
            this.perDeltaCall[i] = callTotal == 0 ? Double.NaN : perDeltaCall[i] / callTotal;
        }
    }

    public double get52wIVHigh() {
        return _52wIVHigh;
    }

    public double get52wIVLow() {
        return _52wIVLow;
    }

    public double getIV() {
        return iv;
    }

    public double get52wHVHigh() {
        return _52wHVHigh;
    }

    public double get52wHVLow() {
        return _52wHVLow;
    }

    public double getHV() {
        return hv;
    }

    public double getPutVolume() {
        return putVolume;
    }

    public double getCallVolume() {
        return callVolume;
    }

    public double getPutCallRatio() {
        return putCallRatio;
    }

    public double getVwap() {
        return vwap;
    }

    public double getPutBelowBidFrac() {
        return putBelowBidFrac;
    }

    public double getPutBetweenMarketFrac() {
        return putBetweenMarketFrac;
    }

    public double getPutOverAskFrac() {
        return putOverAskFrac;
    }

    public double getCallBelowBidFrac() {
        return callBelowBidFrac;
    }

    public double getCallBetweenMarketFrac() {
        return callBetweenMarketFrac;
    }

    public double getCallOverAskFrac() {
        return callOverAskFrac;
    }

    public double getTotalBelowBidFrac() {
        return totalBelowBidFrac;
    }

    public double getTotalBetweenMarketFrac() {
        return totalBetweenMarketFrac;
    }

    public double getTotalOverAskFrac() {
        return totalOverAskFrac;
    }

    public double[] getPerDeltaPut() {
        return perDeltaPut;
    }

    public double[] getPerDeltaCall() {
        return perDeltaCall;
    }

    @Override
    public String toString() {
        return "OptionStatisticsData{" +
            "_52wIVHigh=" + _52wIVHigh +
            ", _52wIVLow=" + _52wIVLow +
            ", iv=" + iv +
            ", _52wHVHigh=" + _52wHVHigh +
            ", _52wHVLow=" + _52wHVLow +
            ", hv=" + hv +
            ", putVolume=" + putVolume +
            ", callVolume=" + callVolume +
            ", putCallRatio=" + putCallRatio +
            ", vwap=" + vwap +
            ", putBelowBidFrac=" + putBelowBidFrac +
            ", putBetweenMarketFrac=" + putBetweenMarketFrac +
            ", putOverAskFrac=" + putOverAskFrac +
            ", callBelowBidFrac=" + callBelowBidFrac +
            ", callBetweenMarketFrac=" + callBetweenMarketFrac +
            ", callOverAskFrac=" + callOverAskFrac +
            ", totalBelowBidFrac=" + totalBelowBidFrac +
            ", totalBetweenMarketFrac=" + totalBetweenMarketFrac +
            ", totalOverAskFrac=" + totalOverAskFrac +
            ", perDeltaPut=" + Arrays.toString(perDeltaPut) +
            ", perDeltaCall=" + Arrays.toString(perDeltaCall) +
            '}';
    }
}
