/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common;

import com.devexperts.logging.Logging;
import com.dxfeed.wspt.common.Indicator;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndicatorReader {
    private static final Logging log = Logging.getLogging(IndicatorReader.class);
    private static final Map<String, Integer> seqNums = new HashMap<String, Integer>();
    private final String fileName;
    private String indicatorTag = "";
    private Indicator[] indicators;

    public IndicatorReader(String fileName) {
        this.fileName = fileName;
        this.loadIndicators();
        StringBuilder sb = new StringBuilder(this.indicatorTag);
        for (Indicator indicator : this.indicators) {
            sb.append("[indicator=").append(indicator).append("]");
        }
        this.indicatorTag = sb.toString();
    }

    public Indicator[] getIndicators() {
        return this.indicators;
    }

    private void loadIndicators() {
        ArrayList<Indicator> indicators = new ArrayList<Indicator>();
        try (BufferedReader br = Files.newBufferedReader(Paths.get(this.fileName, new String[0]));){
            List<String> lineList = br.lines().filter(line -> !line.isEmpty() && line.charAt(0) != '#').toList();
            Indicator indicator = null;
            boolean contentReading = false;
            for (String line2 : lineList) {
                String cleanLine;
                if (line2.contains("name:")) {
                    indicator = new Indicator();
                    indicator.setName(line2.split(":", 2)[1]);
                    contentReading = false;
                    indicators.add(indicator);
                    continue;
                }
                if (line2.contains("lang:")) {
                    assert (indicator == null);
                    indicator.setLang(line2.split(":", 2)[1]);
                    continue;
                }
                if (line2.contains("content:")) {
                    assert (indicator == null);
                    contentReading = true;
                    indicator.setContent(line2.split(":", 2)[1]);
                    continue;
                }
                if (!contentReading || (cleanLine = this.cleanContentLine(line2)).isEmpty()) continue;
                indicator.setContent(indicator.getContent() + (indicator.getContent().isEmpty() ? "" : ";") + this.cleanContentLine(line2));
            }
        }
        catch (NoSuchFileException e) {
            log.info("There is no file indicator in this path: " + this.fileName + ". Please check again.");
        }
        catch (IOException e) {
            log.info("Got an  an IOException: ", (Throwable)e);
        }
        this.indicators = (Indicator[])indicators.toArray(Indicator[]::new);
    }

    public String getRanIndicator() {
        int ran = (int)Math.floor(Math.random() * (double)this.indicators.length);
        return this.indicators[ran].toString();
    }

    public String getIndicatorBySequence(String seqName) {
        seqNums.putIfAbsent(seqName, 0);
        int seqNum = seqNums.get(seqName);
        if (seqNum == this.indicators.length) {
            seqNum = 0;
        }
        String indicator = this.indicators[seqNum].toString();
        seqNums.put(seqName, seqNum + 1);
        return indicator;
    }

    private String cleanContentLine(String contentLine) {
        int commentIdx = ((String)contentLine).indexOf("//");
        if (commentIdx >= 0) {
            contentLine = ((String)contentLine).substring(0, commentIdx);
        }
        int startIdx = 0;
        int endIdx = 0;
        while (startIdx >= 0 && endIdx >= 0) {
            startIdx = ((String)contentLine).indexOf("/*", endIdx);
            endIdx = ((String)contentLine).indexOf("*/", endIdx);
            if (startIdx < 0 || endIdx < 0) continue;
            contentLine = ((String)contentLine).substring(0, startIdx) + ((String)contentLine).substring(endIdx + 2);
        }
        if (!((String)(contentLine = ((String)contentLine).trim())).isEmpty() && ((String)contentLine).charAt(((String)contentLine).length() - 1) == ';') {
            contentLine = ((String)contentLine).substring(0, ((String)contentLine).length() - 1);
        }
        return contentLine;
    }

    public String getIndicatorTag() {
        return this.indicatorTag;
    }
}

