/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.commands;

import com.devexperts.logging.Logging;
import com.dxfeed.wspt.common.commands.ChannelCommand;
import com.dxfeed.wspt.common.commands.Command;
import java.util.Arrays;

public class IndiChartSetupCommand
extends Command
implements ChannelCommand {
    private static final Logging log = Logging.getLogging(IndiChartSetupCommand.class);
    private final int channel;
    private double acceptAggregationPeriod;
    private String acceptDataFormat;
    private String[] acceptCandleFields;

    public IndiChartSetupCommand(int channel, double acceptAggregationPeriod, String acceptDataFormat, String[] acceptCandleFields) {
        this.channel = channel;
        this.acceptAggregationPeriod = acceptAggregationPeriod;
        this.acceptDataFormat = acceptDataFormat;
        this.acceptCandleFields = acceptCandleFields;
    }

    @Override
    public void execute() throws Exception {
        log.info("[" + this.client.getConnectionId() + "] - execute.");
        if (!this.client.isConnected()) {
            this.client.close();
            throw new Exception("The client is not connected.");
        }
        this.client.indiChartSetup(this.channel, this.acceptAggregationPeriod, this.acceptDataFormat, this.acceptCandleFields);
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    public double getAcceptAggregationPeriod() {
        return this.acceptAggregationPeriod;
    }

    public void setAcceptAggregationPeriod(double acceptAggregationPeriod) {
        this.acceptAggregationPeriod = acceptAggregationPeriod;
    }

    public String getAcceptDataFormat() {
        return this.acceptDataFormat;
    }

    public void setAcceptDataFormat(String acceptDataFormat) {
        this.acceptDataFormat = acceptDataFormat;
    }

    public String[] getAcceptCandleFields() {
        return this.acceptCandleFields;
    }

    public void setAcceptCandleFields(String[] acceptCandleFields) {
        this.acceptCandleFields = acceptCandleFields;
    }

    @Override
    public Command clone() {
        return new IndiChartSetupCommand(this.channel, this.acceptAggregationPeriod, this.acceptDataFormat, this.acceptCandleFields);
    }

    public String toString() {
        return "indiChartSetup[channel=" + this.channel + "][acceptAggregationPeriod=" + this.acceptAggregationPeriod + "][acceptDataFormat=" + this.acceptDataFormat + "][acceptCandleFields=" + Arrays.toString(this.acceptCandleFields) + "]";
    }
}

