/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.commands;

import com.devexperts.logging.Logging;
import com.dxfeed.wspt.common.commands.ChannelCommand;
import com.dxfeed.wspt.common.commands.Command;
import java.util.Map;

public class IndiChartSubCommand
extends Command
implements ChannelCommand {
    private static final Logging log = Logging.getLogging(IndiChartSubCommand.class);
    private final int channel;
    private String symbol;
    private long fromTime;
    private Map<String, Map> indiParam;

    public IndiChartSubCommand(int channel, String symbol, long fromTime, Map<String, Map> indiParam) {
        this.symbol = symbol;
        this.channel = channel;
        this.fromTime = fromTime;
        this.indiParam = indiParam;
    }

    @Override
    public void execute() throws Exception {
        log.info("[" + this.client.getConnectionId() + "] - execute.");
        if (!this.client.isConnected()) {
            this.client.close();
            throw new Exception("The client is not connected.");
        }
        this.client.indiChartSubscribe(this.channel, this.symbol, this.fromTime, this.indiParam);
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public long getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(long fromTime) {
        this.fromTime = fromTime;
    }

    public Map<String, Map> getIndiParam() {
        return this.indiParam;
    }

    public void setIndiParam(Map<String, Map> indiParam) {
        this.indiParam = indiParam;
    }

    @Override
    public Command clone() {
        return new IndiChartSubCommand(this.channel, this.symbol, this.fromTime, this.indiParam);
    }

    public String toString() {
        return "indiChartSub[channel=" + this.channel + "][symbol=" + this.symbol + "][fromTime=" + this.fromTime + "][indicators=" + this.indiParam.toString() + "]";
    }
}

