/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.commands;

import com.devexperts.logging.Logging;
import com.dxfeed.wspt.common.commands.ChannelCommand;
import com.dxfeed.wspt.common.commands.Command;
import com.dxfeed.wspt.common.constants.SERVICETYPE;
import com.dxfeed.wspt.scriptplayer.ClientConnectParams;
import java.util.Arrays;
import java.util.Map;

public class ChannelRequestCommand
extends Command
implements ChannelCommand {
    private static final Logging log = Logging.getLogging(ChannelRequestCommand.class);
    private final SERVICETYPE service;
    private final int channel;
    private final String domSymbol;
    private final String[] domSources;
    private final Map<String, Map> chartIndicator;

    public ChannelRequestCommand(SERVICETYPE service, int channel, String domSymbol, String[] domSources, Map<String, Map> chartIndicator) {
        this.service = service;
        this.channel = channel;
        this.domSymbol = domSymbol;
        this.domSources = domSources;
        this.chartIndicator = chartIndicator;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    public SERVICETYPE getService() {
        return this.service;
    }

    @Override
    public void execute() {
        log.info("channelrequest[channel=" + this.channel + "][service=" + String.valueOf((Object)this.service) + "]" + (String)(this.service == SERVICETYPE.DOM ? "[symbol=" + this.domSymbol + "][sources=" + Arrays.toString(this.domSources) + "]" : "") + (String)(this.service == SERVICETYPE.INDICHART ? "[chartIndi=" + String.valueOf(this.chartIndicator) + "]" : "") + " - execute.");
        this.client.channelRequest(this.channel, this.service, this.service == SERVICETYPE.DOM ? ClientConnectParams.buildDomParams(this.domSymbol, this.domSources) : (this.service == SERVICETYPE.INDICHART ? ClientConnectParams.buildIndiChartParams(this.chartIndicator) : null));
    }

    @Override
    public Command clone() {
        return new ChannelRequestCommand(this.service, this.channel, this.domSymbol, this.domSources, this.chartIndicator);
    }

    public String toString() {
        return "channelRequest[channel=" + this.channel + "][service=" + String.valueOf((Object)this.service) + "]" + (String)(SERVICETYPE.DOM == this.service ? "[symbol=" + this.domSymbol + "][sources=" + String.join((CharSequence)", ", this.domSources) + "]" : "") + (String)(this.service == SERVICETYPE.INDICHART ? "[chartIndi=" + this.chartIndicator.toString() + "]" : "");
    }
}

