/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.commands;

import com.dxfeed.wspt.common.commands.Command;
import com.dxfeed.wspt.common.commands.commandparsers.AddSubCommandParser;
import com.dxfeed.wspt.common.commands.commandparsers.ChannelCloseCommandParser;
import com.dxfeed.wspt.common.commands.commandparsers.ChannelRequestCommandParser;
import com.dxfeed.wspt.common.commands.commandparsers.CommandParser;
import com.dxfeed.wspt.common.commands.commandparsers.ConnectCommandParser;
import com.dxfeed.wspt.common.commands.commandparsers.DelayCommandParser;
import com.dxfeed.wspt.common.commands.commandparsers.DisconnectCommandParser;
import com.dxfeed.wspt.common.commands.commandparsers.IndiChartRemoveIndiCommandParser;
import com.dxfeed.wspt.common.commands.commandparsers.IndiChartSetupCommandParser;
import com.dxfeed.wspt.common.commands.commandparsers.IndiChartSubCommandParser;
import com.dxfeed.wspt.common.commands.commandparsers.RemoveSubCommandParser;
import com.dxfeed.wspt.common.commands.commandparsers.ResetCommandParser;
import java.util.Map;

public class CommandFactory {
    private static CommandFactory factory;
    private int maxNumSymbols;
    private Boolean forceTimeout;
    private Map<String, String> scriptMap;

    public static synchronized CommandFactory getInstance() {
        if (factory == null) {
            factory = new CommandFactory();
        }
        return factory;
    }

    public static CommandFactory setConfigs(int maxNumSymbols, Boolean forceTimeout, Map<String, String> scriptMap) {
        CommandFactory.getInstance().setMaxNumSymbols(maxNumSymbols).setForceTimeout(forceTimeout).setScriptMap(scriptMap);
        return factory;
    }

    public Command buildCommand(String command, int loop) {
        CommandParser cmdPrsr = null;
        if (command.indexOf("delay") == 0) {
            cmdPrsr = new DelayCommandParser();
        } else if (command.indexOf("connect") == 0) {
            cmdPrsr = new ConnectCommandParser(loop);
        } else if (command.indexOf("channelRequest") == 0) {
            cmdPrsr = new ChannelRequestCommandParser(this.scriptMap);
        } else if (command.indexOf("disconnect") == 0) {
            cmdPrsr = this.forceTimeout == null ? (command.length() >= 24 && "[timeout=true]".equals(command.substring(10, 24)) ? new DisconnectCommandParser(true) : new DisconnectCommandParser(false)) : new DisconnectCommandParser(this.forceTimeout);
        } else if (command.indexOf("add=") == 0 || command.indexOf("add[") == 0) {
            cmdPrsr = new AddSubCommandParser(this.maxNumSymbols);
        } else if (command.indexOf("remove=") == 0 || command.indexOf("remove[") == 0) {
            cmdPrsr = new RemoveSubCommandParser(this.maxNumSymbols);
        } else if (command.indexOf("reset") == 0) {
            cmdPrsr = new ResetCommandParser();
        } else if (command.indexOf("indiChartSub=") == 0 || command.indexOf("indiChartSub[") == 0) {
            cmdPrsr = new IndiChartSubCommandParser();
        } else if (command.indexOf("indiChartRemoveIndi=") == 0 || command.indexOf("indiChartRemoveIndi[") == 0) {
            cmdPrsr = new IndiChartRemoveIndiCommandParser();
        } else if (command.indexOf("indiChartSetup=") == 0 || command.indexOf("indiChartSetup[") == 0) {
            cmdPrsr = new IndiChartSetupCommandParser();
        } else if (command.indexOf("channelClose=") == 0 || command.indexOf("channelClose[") == 0) {
            cmdPrsr = new ChannelCloseCommandParser();
        }
        return cmdPrsr != null ? cmdPrsr.parser(command) : null;
    }

    public CommandFactory setMaxNumSymbols(int maxNumSymbols) {
        this.maxNumSymbols = maxNumSymbols;
        return this;
    }

    public CommandFactory setForceTimeout(Boolean forceTimeout) {
        this.forceTimeout = forceTimeout;
        return this;
    }

    public CommandFactory setScriptMap(Map<String, String> scriptMap) {
        this.scriptMap = scriptMap;
        return this;
    }
}

