/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.commands.commandparsers;

import com.dxfeed.wspt.common.commands.AddSubCommand;
import com.dxfeed.wspt.common.commands.Command;
import com.dxfeed.wspt.common.commands.commandparsers.CommandParser;
import com.dxfeed.wspt.common.utils.TypeHelper;
import java.util.Map;

public class AddSubCommandParser
implements CommandParser {
    final int maxNumSymbols;

    public AddSubCommandParser(int maxNumSymbols) {
        this.maxNumSymbols = maxNumSymbols;
    }

    @Override
    public Command parser(String command) {
        int channel = 1;
        Map<String, Object> subMap = null;
        if (command.length() > 4) {
            String[] params;
            for (String param : params = command.substring(4, command.length() - 1).split("]\\[")) {
                if (param.contains("channel=")) {
                    channel = Integer.parseInt(param.substring(8));
                    continue;
                }
                if (param.contains("sub=")) {
                    String commandSub = param.substring(4);
                    subMap = TypeHelper.parseSub(commandSub);
                    continue;
                }
                if (!param.contains("ipf=")) continue;
                String[] pair = param.substring(4).split(", ");
                String type = pair[0];
                String idfPath = pair[1];
                subMap = TypeHelper.addSubMapKeyByIdf(type, idfPath);
            }
        }
        return new AddSubCommand(channel, TypeHelper.breakDownSubmap(subMap, this.maxNumSymbols));
    }
}

