/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.commands.commandparsers;

import com.dxfeed.wspt.common.commands.Command;
import com.dxfeed.wspt.common.commands.IndiChartSetupCommand;
import com.dxfeed.wspt.common.commands.commandparsers.CommandParser;

public class IndiChartSetupCommandParser
implements CommandParser {
    @Override
    public Command parser(String command) {
        int channel = 1;
        double acceptAggregationPeriod = 0.0;
        String acceptDataFormat = "FULL";
        String[] acceptCandleFields = null;
        if (command.length() > 15) {
            String[] params;
            for (String param : params = command.substring(15, command.length() - 1).split("]\\[")) {
                if (param.contains("channel=")) {
                    channel = Integer.parseInt(param.substring(8));
                    continue;
                }
                if (param.contains("acceptAggregationPeriod=")) {
                    acceptAggregationPeriod = Double.parseDouble(param.substring(24));
                    continue;
                }
                if (param.contains("acceptDataFormat=")) {
                    acceptDataFormat = param.substring(17);
                    continue;
                }
                if (!param.contains("acceptCandleFields=")) continue;
                acceptCandleFields = param.substring(19).isEmpty() ? new String[]{} : param.substring(19).split(", ");
            }
        }
        return new IndiChartSetupCommand(channel, acceptAggregationPeriod, acceptDataFormat, acceptCandleFields);
    }
}

