/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.commands.commandparsers;

import com.dxfeed.wspt.common.commands.Command;
import com.dxfeed.wspt.common.commands.IndiChartSubCommand;
import com.dxfeed.wspt.common.commands.commandparsers.CommandParser;
import java.util.HashMap;
import java.util.Map;

public class IndiChartSubCommandParser
implements CommandParser {
    @Override
    public Command parser(String command) {
        int channel = 1;
        String symbol = "";
        long fromTime = 0L;
        HashMap<String, Map> indiParams = new HashMap<String, Map>();
        if (command.length() > 13) {
            String[] params;
            for (String param : params = command.substring(13, command.length() - 1).split("]\\[")) {
                if (param.contains("channel=")) {
                    channel = Integer.parseInt(param.substring(8));
                    continue;
                }
                if (param.contains("symbol=")) {
                    symbol = param.substring(7);
                    continue;
                }
                if (param.contains("fromTime=")) {
                    fromTime = Long.parseLong(param.substring(9));
                    continue;
                }
                if (!param.contains("indicators=")) continue;
                String indicators = param.substring(11);
                String[] indiSet = indicators.split(", ");
                String indiName = "";
                for (String indi : indiSet) {
                    if (indi.contains("name:")) {
                        indiName = indi.substring(5);
                        indiParams.put(indi.substring(5), new HashMap());
                        continue;
                    }
                    if (indiName.isEmpty()) continue;
                    String[] indiPair = indi.split(":", 2);
                    String key = indiPair[0];
                    String value = indiPair[1];
                    if (indiPair[1].contains("number(") && indiPair[1].contains(".")) {
                        ((Map)indiParams.get(indiName)).put(key, Double.parseDouble(value.substring(7, value.length() - 1)));
                        continue;
                    }
                    if (indiPair[1].contains("number(")) {
                        ((Map)indiParams.get(indiName)).put(key, Integer.parseInt(value.substring(7, value.length() - 1)));
                        continue;
                    }
                    if (indiPair[1].contains("string(")) {
                        ((Map)indiParams.get(indiName)).put(key, value.substring(7, value.length() - 1));
                        continue;
                    }
                    if (!indiPair[1].contains("boolean(")) continue;
                    ((Map)indiParams.get(indiName)).put(key, Boolean.parseBoolean(value.substring(8, value.length() - 1)));
                }
            }
        }
        return new IndiChartSubCommand(channel, symbol, fromTime, indiParams);
    }
}

