/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.metrics;

import java.util.concurrent.atomic.AtomicLong;
import org.HdrHistogram.Histogram;

public class CalculatedLatencyMetric {
    private final Histogram h = new Histogram(3);
    private final AtomicLong max = new AtomicLong(-1L);
    private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong total = new AtomicLong(0L);
    private final AtomicLong sum = new AtomicLong(0L);
    private final AtomicLong avg = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regLatency(long latency) {
        Histogram histogram = this.h;
        synchronized (histogram) {
            this.h.recordValue(latency);
        }
        this.total.getAndIncrement();
        this.sum.getAndAdd(latency);
        this.min.set(Long.min(latency, this.min.get()));
        this.max.set(Long.max(latency, this.max.get()));
        this.avg.set(this.sum.get() / this.total.get());
    }

    public long get95thLatency() {
        return this.h.getValueAtPercentile(95.0);
    }

    public String getMaxText() {
        return this.max.get() == -1L ? "NaN" : "" + this.max.get();
    }

    public String getMinText() {
        return this.min.get() == Long.MAX_VALUE ? "NaN" : "" + this.min.get();
    }

    public long getAvg() {
        return this.avg.get();
    }

    public void clear() {
        this.max.set(-1L);
        this.min.set(Long.MAX_VALUE);
        this.total.set(0L);
        this.sum.set(0L);
        this.avg.set(0L);
        this.h.reset();
    }

    public long getMaxNum() {
        return this.max.get() == -1L ? 0L : this.max.get();
    }

    public long getMinNum() {
        return this.min.get() == Long.MAX_VALUE ? 0L : this.min.get();
    }

    public long getAvgNum() {
        return this.avg.get();
    }
}

