/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.metrics;

import com.devexperts.logging.Logging;
import com.dxfeed.wspt.common.constants.SERVICETYPE;
import com.dxfeed.wspt.common.metrics.ScriptPlayerStats;
import com.dxfeed.wspt.common.metrics.events.AcceptDomEventListener;
import com.dxfeed.wspt.common.metrics.events.AcceptFeedEventListener;
import com.dxfeed.wspt.common.metrics.events.AcceptIndiChartEventListener;
import com.dxfeed.wspt.common.metrics.events.ChannelDecrementListener;
import com.dxfeed.wspt.common.metrics.events.ChannelIncrementListener;
import com.dxfeed.wspt.common.metrics.events.DomSubscriptionDecrementListener;
import com.dxfeed.wspt.common.metrics.events.DomSubscriptionIncrementListener;
import com.dxfeed.wspt.common.metrics.events.FeedSubscriptionDecrementListener;
import com.dxfeed.wspt.common.metrics.events.FeedSubscriptionIncrementListener;
import com.dxfeed.wspt.common.metrics.events.IndiChartSubscriptionDecrementListener;
import com.dxfeed.wspt.common.metrics.events.IndiChartSubscriptionIncrementListener;
import com.dxfeed.wspt.common.metrics.events.SessionDecrementListener;
import com.dxfeed.wspt.common.metrics.events.SessionIncrementListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class ScriptPlayerStatsCollector {
    private static final Logging log = Logging.getLogging(ScriptPlayerStatsCollector.class);
    protected final ScriptPlayerStats stats;
    private final List<SessionIncrementListener> sessionIncrementListeners = new CopyOnWriteArrayList<SessionIncrementListener>();
    private final List<SessionDecrementListener> sessionDecrementListeners = new CopyOnWriteArrayList<SessionDecrementListener>();
    private final List<ChannelIncrementListener> channelIncrementListeners = new CopyOnWriteArrayList<ChannelIncrementListener>();
    private final List<ChannelDecrementListener> channelDecrementListeners = new CopyOnWriteArrayList<ChannelDecrementListener>();
    private final List<FeedSubscriptionIncrementListener> feedSubscriptionIncrementListeners = new CopyOnWriteArrayList<FeedSubscriptionIncrementListener>();
    private final List<FeedSubscriptionDecrementListener> feedSubscriptionDecrementListeners = new CopyOnWriteArrayList<FeedSubscriptionDecrementListener>();
    private final List<DomSubscriptionIncrementListener> domSubscriptionIncrementListeners = new CopyOnWriteArrayList<DomSubscriptionIncrementListener>();
    private final List<DomSubscriptionDecrementListener> domSubscriptionDecrementListeners = new CopyOnWriteArrayList<DomSubscriptionDecrementListener>();
    private final List<IndiChartSubscriptionIncrementListener> indiChartSubscriptionIncrementListeners = new CopyOnWriteArrayList<IndiChartSubscriptionIncrementListener>();
    private final List<IndiChartSubscriptionDecrementListener> indiChartSubscriptionDecrementListeners = new CopyOnWriteArrayList<IndiChartSubscriptionDecrementListener>();
    private final List<AcceptFeedEventListener> acceptFeedEventListeners = new CopyOnWriteArrayList<AcceptFeedEventListener>();
    private final List<AcceptDomEventListener> acceptDomEventListeners = new CopyOnWriteArrayList<AcceptDomEventListener>();
    private final List<AcceptIndiChartEventListener> acceptIndiChartEventListeners = new CopyOnWriteArrayList<AcceptIndiChartEventListener>();

    public ScriptPlayerStats getStats() {
        return this.stats;
    }

    public void registerSessionIncrementListener(SessionIncrementListener listener) {
        this.sessionIncrementListeners.add(listener);
    }

    public void removeSessionIncrementListener(SessionIncrementListener listener) {
        this.sessionIncrementListeners.remove(listener);
    }

    public void registerSessionDecrementListener(SessionDecrementListener listener) {
        this.sessionDecrementListeners.add(listener);
    }

    public void removeSessionDecrementListener(SessionDecrementListener listener) {
        this.sessionDecrementListeners.remove(listener);
    }

    public void registerChannelIncrementListeners(ChannelIncrementListener listener) {
        this.channelIncrementListeners.add(listener);
    }

    public void removeChannelIncrementListeners(ChannelIncrementListener listener) {
        this.channelIncrementListeners.remove(listener);
    }

    public void registerChannelDecrementListeners(ChannelDecrementListener listener) {
        this.channelDecrementListeners.add(listener);
    }

    public void removeChannelDecrementListeners(ChannelDecrementListener listener) {
        this.channelDecrementListeners.remove(listener);
    }

    public void registerFeedSubscriptionIncrementListeners(FeedSubscriptionIncrementListener listener) {
        this.feedSubscriptionIncrementListeners.add(listener);
    }

    public void removeFeedSubscriptionIncrementListeners(FeedSubscriptionIncrementListener listener) {
        this.feedSubscriptionIncrementListeners.remove(listener);
    }

    public void registerFeedSubscriptionDecrementListeners(FeedSubscriptionDecrementListener listener) {
        this.feedSubscriptionDecrementListeners.add(listener);
    }

    public void removeFeedSubscriptionDecrementListeners(FeedSubscriptionDecrementListener listener) {
        this.feedSubscriptionDecrementListeners.remove(listener);
    }

    public void registerDomSubscriptionIncrementListeners(DomSubscriptionIncrementListener listener) {
        this.domSubscriptionIncrementListeners.add(listener);
    }

    public void removeDomSubscriptionIncrementListeners(DomSubscriptionIncrementListener listener) {
        this.domSubscriptionIncrementListeners.remove(listener);
    }

    public void registerDomSubscriptionDecrementListeners(DomSubscriptionDecrementListener listener) {
        this.domSubscriptionDecrementListeners.add(listener);
    }

    public void removeDomSubscriptionDecrementListeners(DomSubscriptionDecrementListener listener) {
        this.domSubscriptionDecrementListeners.remove(listener);
    }

    public void registerIndiChartSubscriptionIncrementListeners(IndiChartSubscriptionIncrementListener listener) {
        this.indiChartSubscriptionIncrementListeners.add(listener);
    }

    public void removeIndiChartSubscriptionIncrementListeners(IndiChartSubscriptionIncrementListener listener) {
        this.indiChartSubscriptionIncrementListeners.remove(listener);
    }

    public void registerIndiChartSubscriptionDecrementListeners(IndiChartSubscriptionDecrementListener listener) {
        this.indiChartSubscriptionDecrementListeners.add(listener);
    }

    public void removeIndiChartSubscriptionDecrementListeners(IndiChartSubscriptionDecrementListener listener) {
        this.indiChartSubscriptionDecrementListeners.remove(listener);
    }

    public void registerAcceptFeedEventListeners(AcceptFeedEventListener listener) {
        this.acceptFeedEventListeners.add(listener);
    }

    public void removeAcceptFeedEventListeners(AcceptFeedEventListener listener) {
        this.acceptFeedEventListeners.remove(listener);
    }

    public void registerAcceptDomEventListeners(AcceptDomEventListener listener) {
        this.acceptDomEventListeners.add(listener);
    }

    public void removeAcceptDomEventListeners(AcceptDomEventListener listener) {
        this.acceptDomEventListeners.remove(listener);
    }

    public void registerAcceptIndiChartEventListeners(AcceptIndiChartEventListener listener) {
        this.acceptIndiChartEventListeners.add(listener);
    }

    public void removeAcceptIndiChartEventListeners(AcceptIndiChartEventListener listener) {
        this.acceptIndiChartEventListeners.remove(listener);
    }

    public ScriptPlayerStatsCollector(ScriptPlayerStats stats) {
        this.stats = stats;
    }

    public void connect(String connectionId) {
        if (!this.stats.activeConnections.containsKey(connectionId)) {
            this.stats.numAliveConnections.incrementAndGet();
            this.stats.numConnections.incrementAndGet();
            this.sessionIncrementListeners.forEach(listener -> listener.onSessionIncrement(connectionId));
            this.stats.activeConnections.put(connectionId, new ConcurrentHashMap());
        }
    }

    public void connected(String connectionId) {
    }

    public void disconnected(String connectionId) {
        if (this.stats.activeConnections.containsKey(connectionId)) {
            this.stats.numAliveConnections.decrementAndGet();
            this.stats.numAliveChannels.addAndGet(-this.stats.activeConnections.get(connectionId).size());
            this.stats.activeConnections.get(connectionId).forEach((channel, serviceType) -> {
                if (serviceType == SERVICETYPE.INDICHART) {
                    this.stats.indiChartActiveSubscriptionSize.decrementAndGet();
                } else if (serviceType == SERVICETYPE.DOM) {
                    this.stats.domActiveSubscriptionSize.decrementAndGet();
                }
            });
            this.stats.activeConnections.remove(connectionId);
            this.stats.feedSubStartTime.remove(connectionId);
            this.stats.domChannelStartTime.remove(connectionId);
            this.stats.indiChartChannelStartTime.remove(connectionId);
            if (this.stats.feedSubscriptions.containsKey(connectionId)) {
                this.stats.feedActiveSubscriptionSize.addAndGet(-this.stats.feedSubscriptions.get(connectionId).values().stream().mapToInt(channel -> channel.values().stream().mapToInt(Set::size).sum()).sum());
                this.stats.feedSubscriptions.remove(connectionId);
            }
            this.sessionDecrementListeners.forEach(listener -> listener.onSessionDecrement(connectionId));
        }
    }

    public void channelRequest(String connectionId, int channel, SERVICETYPE servicetype) {
        if (this.stats.activeConnections.containsKey(connectionId) && !this.stats.activeConnections.get(connectionId).containsKey(channel)) {
            this.stats.activeConnections.get(connectionId).put(channel, servicetype);
            this.stats.numChannels.incrementAndGet();
            this.stats.numAliveChannels.incrementAndGet();
            if (servicetype == SERVICETYPE.DOM) {
                this.stats.domChannelStartTime.putIfAbsent(connectionId, new ConcurrentHashMap());
                this.stats.domChannelStartTime.get(connectionId).putIfAbsent(channel, System.currentTimeMillis());
                this.stats.domSubscriptionSize.incrementAndGet();
                this.domSubscriptionIncrementListeners.forEach(listener -> listener.onDomSubscriptionModeSumIncrement(connectionId, channel));
            }
            this.channelIncrementListeners.forEach(listener -> listener.onChannelIncrement(connectionId, channel, servicetype));
        }
    }

    public void closeChannel(String connectionId, int channel) {
        if (this.stats.activeConnections.containsKey(connectionId) && this.stats.activeConnections.get(connectionId).containsKey(channel)) {
            SERVICETYPE servicetype = this.stats.activeConnections.get(connectionId).get(channel);
            this.stats.activeConnections.get(connectionId).remove(channel);
            this.stats.numAliveChannels.decrementAndGet();
            if (servicetype == SERVICETYPE.INDICHART) {
                this.stats.indiChartActiveSubscriptionSize.decrementAndGet();
            } else if (servicetype == SERVICETYPE.DOM) {
                this.stats.domActiveSubscriptionSize.decrementAndGet();
            }
            this.channelDecrementListeners.forEach(listener -> listener.onChannelDecrement(connectionId, channel));
            if (this.stats.feedSubscriptions.containsKey(connectionId) && this.stats.feedSubscriptions.get(connectionId).containsKey(channel)) {
                this.stats.feedActiveSubscriptionSize.addAndGet(-this.stats.feedSubscriptions.get(connectionId).get(channel).values().stream().mapToInt(Set::size).sum());
                this.stats.feedSubscriptions.get(connectionId).remove(channel);
            }
        }
    }

    public void feedSubscribe(String connectionId, int channel, Map<String, Object> subMap) {
        this.stats.feedSubscriptions.putIfAbsent(connectionId, new ConcurrentHashMap());
        this.stats.feedSubscriptions.get(connectionId).putIfAbsent(channel, new ConcurrentHashMap());
        int delta = 0;
        for (Map item : (List)subMap.get("subList")) {
            String type = (String)item.get("type");
            String symbol = (String)item.get("symbol");
            this.stats.feedSubscriptions.get(connectionId).get(channel).putIfAbsent(type, ConcurrentHashMap.newKeySet());
            if (this.stats.feedSubscriptions.get(connectionId).get(channel).get(type).contains(symbol)) continue;
            this.stats.feedSubscriptions.get(connectionId).get(channel).get(type).add(symbol);
            this.stats.feedSubscriptionSize.incrementAndGet();
            this.stats.feedActiveSubscriptionSize.incrementAndGet();
            ++delta;
            this.stats.feedSubStartTime.putIfAbsent(connectionId, new ConcurrentHashMap());
            this.stats.feedSubStartTime.get(connectionId).putIfAbsent(channel, new ConcurrentHashMap());
            this.stats.feedSubStartTime.get(connectionId).get(channel).put(type + "_" + symbol, System.currentTimeMillis());
        }
        int finalDelta = delta;
        this.feedSubscriptionIncrementListeners.forEach(listener -> listener.onFeedSubscriptionModSumIncrement(connectionId, channel, subMap, finalDelta));
    }

    public void feedUnSubscribe(String connectionId, int channel, Map<String, Object> subMap) {
        for (Map item : (List)subMap.get("subList")) {
            if (!this.stats.feedSubscriptions.containsKey(connectionId) || !this.stats.feedSubscriptions.get(connectionId).containsKey(channel) || !this.stats.feedSubscriptions.get(connectionId).get(channel).containsKey((String)item.get("type")) || !this.stats.feedSubscriptions.get(connectionId).get(channel).get((String)item.get("type")).contains((String)item.get("symbol"))) continue;
            this.stats.feedSubscriptions.get(connectionId).get(channel).get((String)item.get("type")).remove((String)item.get("symbol"));
            if (this.stats.feedSubscriptions.get(connectionId).get(channel).get((String)item.get("type")).isEmpty()) {
                this.stats.feedSubscriptions.get(connectionId).get(channel).remove((String)item.get("type"));
            }
            this.stats.feedActiveSubscriptionSize.decrementAndGet();
        }
        this.feedSubscriptionDecrementListeners.forEach(listener -> listener.onFeedSubscriptionDecrement(connectionId, channel));
    }

    public void feedReset(String connectionId, int channel) {
        if (this.stats.feedSubscriptions.containsKey(connectionId) && this.stats.feedSubscriptions.get(connectionId).containsKey(channel)) {
            this.stats.feedActiveSubscriptionSize.getAndAdd(-this.stats.feedSubscriptions.get(connectionId).get(channel).values().stream().mapToInt(Set::size).sum());
            this.stats.feedSubscriptions.get(connectionId).get(channel).clear();
            this.feedSubscriptionDecrementListeners.forEach(listener -> listener.onFeedSubscriptionDecrement(connectionId, channel));
        }
    }

    public void indiChartSubscribe(String connectionId, int channel) {
        this.stats.indiChartChannelStartTime.putIfAbsent(connectionId, new ConcurrentHashMap());
        this.stats.indiChartChannelStartTime.get(connectionId).putIfAbsent(channel, System.currentTimeMillis());
        this.stats.indiChartSubscriptionSize.incrementAndGet();
        this.stats.indiChartActiveSubscriptionSize.incrementAndGet();
        this.indiChartSubscriptionIncrementListeners.forEach(listener -> listener.onIndiChartSubscriptionModeSumIncrement(connectionId, channel));
    }

    public void acceptFeedEvent(String connectionId, int channel, List<Map<String, Object>> events) {
        this.stats.feedMessagesCount.incrementAndGet();
        this.stats.feedEventsCount.addAndGet(events.size());
        this.stats.feedEventsCountPerConnection.putIfAbsent(connectionId, new AtomicLong(0L));
        this.stats.feedEventsCountPerConnection.get(connectionId).addAndGet(events.size());
        this.stats.feedMessagesCountPerConnection.putIfAbsent(connectionId, new AtomicLong(0L));
        this.stats.feedMessagesCountPerConnection.get(connectionId).incrementAndGet();
        this.acceptFeedEventListeners.forEach(listener -> listener.onAcceptFeedEvent(connectionId, channel, events));
        events.forEach(event -> {
            String eventKey = event.get("eventType").toString() + "_" + event.get("eventSymbol").toString();
            if (this.stats.feedSubStartTime.containsKey(connectionId) && this.stats.feedSubStartTime.get(connectionId).containsKey(channel) && this.stats.feedSubStartTime.get(connectionId).get(channel).containsKey(eventKey)) {
                Long startTime = this.stats.feedSubStartTime.get(connectionId).get(channel).get(eventKey);
                long latency = System.currentTimeMillis() - startTime;
                this.stats.feedLatencyMetric.regLatency(latency);
                this.stats.feedSubStartTime.get(connectionId).get(channel).remove(eventKey);
            }
        });
    }

    public void acceptDomEvent(String connectionId, int channel, List<Map<String, Object>> bids, List<Map<String, Object>> asks) {
        this.stats.domMessagesCount.incrementAndGet();
        this.stats.domEventsCount.addAndGet(bids.size());
        this.stats.domEventsCount.addAndGet(asks.size());
        this.acceptDomEventListeners.forEach(listener -> listener.onAcceptDomEvent(connectionId, channel, bids, asks));
        if (this.stats.domChannelStartTime.containsKey(connectionId) && this.stats.domChannelStartTime.get(connectionId).containsKey(channel)) {
            Long startTime = this.stats.domChannelStartTime.get(connectionId).get(channel);
            long latency = System.currentTimeMillis() - startTime;
            this.stats.domLatencyMetric.regLatency(latency);
            this.stats.domChannelStartTime.get(connectionId).remove(channel);
        }
    }

    public void acceptIndiChartEvent(String connectionId, int channel, List<Map<String, Object>> candles) {
        this.stats.indiChartMessagesCount.incrementAndGet();
        this.stats.indiChartEventsCount.addAndGet(candles.size());
        this.acceptIndiChartEventListeners.forEach(listener -> listener.onAcceptIndiChartEvent(connectionId, channel, candles));
        if (this.stats.indiChartChannelStartTime.containsKey(connectionId) && this.stats.indiChartChannelStartTime.get(connectionId).containsKey(channel)) {
            Long startTime = this.stats.indiChartChannelStartTime.get(connectionId).get(channel);
            long latency = System.currentTimeMillis() - startTime;
            this.stats.indiChartLatencyMetric.regLatency(latency);
            this.stats.indiChartChannelStartTime.get(connectionId).remove(channel);
        }
    }
}

