/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.utils;

import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeHelper {
    private static final Pattern TIME_PATTERN = Pattern.compile("(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?(?:(\\d+)ms)?", 2);

    public static String getDelayTime(Date startTime, Date endTime, double multiplier) {
        return DateTimeHelper.getDelayTimeWithGap(startTime, endTime, 0L, multiplier);
    }

    public static String getDelayTimeWithGap(Date startTime, Date endTime, long gapDelay, double multiplier) {
        if (startTime.getTime() < endTime.getTime()) {
            long mlsTotal = (long)(multiplier * (double)(endTime.getTime() - startTime.getTime() + gapDelay));
            return DateTimeHelper.fromMlsDurationToDelayFormat(mlsTotal);
        }
        return "0:0:0:0";
    }

    public static String fromMlsDurationToDelayFormat(long mlsDuration) {
        long mls = mlsDuration % 1000L;
        long sc = (mlsDuration - mls) / 1000L % 60L;
        long mn = (mlsDuration - mls - 1000L * sc) / 1000L / 60L % 60L;
        long hr = (mlsDuration - mls - 1000L * sc - 60000L * mn) / 1000L / 60L / 60L;
        return hr + ":" + mn + ":" + sc + ":" + mls;
    }

    public static long fromDelayFormatToMlsDuration(String delay) {
        Integer[] timeStack = (Integer[])Arrays.stream(delay.split(":")).map(Integer::parseInt).toArray(Integer[]::new);
        return 3600000L * (long)timeStack[0].intValue() + 60000L * (long)timeStack[1].intValue() + 1000L * (long)timeStack[2].intValue() + (long)timeStack[3].intValue();
    }

    public static long from1h1m1s1msFormatToMlsDuration(String input) {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException("Time string cannot be null or empty");
        }
        Matcher matcher = TIME_PATTERN.matcher(input.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid time format: " + input);
        }
        long hours = matcher.group(1) != null ? Long.parseLong(matcher.group(1)) : 0L;
        long minutes = matcher.group(2) != null ? Long.parseLong(matcher.group(2)) : 0L;
        long seconds = matcher.group(3) != null ? Long.parseLong(matcher.group(3)) : 0L;
        long millis = matcher.group(4) != null ? Long.parseLong(matcher.group(4)) : 0L;
        return hours * 3600000L + minutes * 60000L + seconds * 1000L + millis;
    }
}

