/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.utils;

import com.devexperts.mdd.auth.util.SignedToken;
import com.dxfeed.wspt.common.commands.Command;
import com.dxfeed.wspt.common.commands.ConnectCommand;
import com.dxfeed.wspt.common.commands.DelayCommand;
import java.time.Duration;
import java.time.temporal.TemporalAmount;

public class TokenHelper {
    public static String generateToken(String user, String overrideUserIssuer, String overrideUserSessionType, String secret, long expiration) {
        int idx1 = user.indexOf(47);
        int idx2 = user.indexOf(64);
        String issuer = overrideUserIssuer.isEmpty() ? user.substring(0, idx1) : overrideUserIssuer;
        String userName = user.substring(idx1 + 1, idx2);
        String sessionType = overrideUserSessionType.isEmpty() ? user.substring(idx2 + 1) : overrideUserSessionType;
        return SignedToken.newBuilder().setIssuer(issuer).setSubject(sessionType).setMessage(userName + ",stocks;options").setIssuedNow().setExpirationFromNow((TemporalAmount)Duration.ofMillis(expiration)).toToken().signToken(secret);
    }

    public static long calGenTokenExp(Command[] commands) {
        long totalDelay = 0L;
        for (Command command : commands) {
            if (command.getClass() == ConnectCommand.class) {
                totalDelay += ((ConnectCommand)command).getInMiliseconds();
                continue;
            }
            if (command.getClass() != DelayCommand.class) continue;
            totalDelay += ((DelayCommand)command).getDuration();
        }
        return totalDelay + 3600000L;
    }
}

