/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.commands.commandparsers;

import com.dxfeed.wspt.common.commands.Command;
import com.dxfeed.wspt.common.commands.ConnectCommand;
import com.dxfeed.wspt.common.commands.commandparsers.CommandParser;

public class ConnectCommandParser
implements CommandParser {
    private final int loop;

    public ConnectCommandParser(int loop) {
        this.loop = loop;
    }

    @Override
    public Command parser(String command) {
        String[] params;
        int numberUsers = 1;
        String connectionId = null;
        String token = null;
        String user = null;
        int eventLimit = 0;
        long inMiliseconds = 0L;
        for (String param : params = command.substring(8, command.length() - 1).split("]\\[")) {
            String[] keyValue = param.split("=");
            if (keyValue.length != 2) continue;
            if ("user".equals(keyValue[0])) {
                try {
                    numberUsers = Integer.parseInt(keyValue[1].substring(1));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("connectionId".equals(keyValue[0])) {
                connectionId = keyValue[1];
                continue;
            }
            if ("token".equals(keyValue[0])) {
                token = keyValue[1];
                continue;
            }
            if ("userId".equals(keyValue[0])) {
                user = keyValue[1];
                continue;
            }
            if ("eventLimit".equals(keyValue[0])) {
                try {
                    eventLimit = Integer.parseInt(keyValue[1]);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!"in".equals(keyValue[0])) continue;
            long unitNumber = Long.parseLong(keyValue[1].substring(0, keyValue[1].length() - 1));
            char unit = keyValue[1].charAt(keyValue[1].length() - 1);
            if (unit == 'h') {
                inMiliseconds = 3600000L * unitNumber;
                continue;
            }
            if (unit == 'm') {
                inMiliseconds = 60000L * unitNumber;
                continue;
            }
            if (unit != 's') continue;
            inMiliseconds = 1000L * unitNumber;
        }
        return new ConnectCommand(numberUsers, connectionId, connectionId + "_" + this.loop, token, user, eventLimit, inMiliseconds);
    }
}

