/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.commands;

import com.devexperts.logging.Logging;
import com.dxfeed.wspt.common.commands.Command;

public class DisconnectCommand
extends Command {
    private static final Logging log = Logging.getLogging(DisconnectCommand.class);
    private final boolean timeout;

    public DisconnectCommand(boolean timeout) {
        this.timeout = timeout;
    }

    @Override
    public void execute() throws Exception {
        log.info("[" + this.client.getConnectionId() + "] - execute.");
        if (!this.client.isConnected()) {
            this.client.close();
            throw new Exception("The client is not connected.");
        }
        this.client.disconnect(this.timeout);
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    @Override
    public Command clone() {
        return new DisconnectCommand(this.timeout);
    }

    public String toString() {
        return "disconnect[timeout=" + this.isTimeout() + "]";
    }
}

