/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.commands;

import com.devexperts.logging.Logging;
import com.dxfeed.wspt.common.commands.ChannelCommand;
import com.dxfeed.wspt.common.commands.Command;
import com.dxfeed.wspt.common.utils.HashHelper;
import java.util.Map;

public class RemoveSubCommand
extends Command
implements ChannelCommand {
    private static final Logging log = Logging.getLogging(RemoveSubCommand.class);
    private final int channel;
    private Map<String, Object>[] subMaps;

    public RemoveSubCommand(int channel, Map<String, Object>[] subMaps) {
        this.subMaps = subMaps;
        this.channel = channel;
    }

    public Map<String, Object>[] getSubMaps() {
        return this.subMaps;
    }

    public void setSubMaps(Map<String, Object>[] subMaps) {
        this.subMaps = subMaps;
    }

    @Override
    public void execute() throws Exception {
        log.info("[" + this.client.getConnectionId() + "] - execute.");
        if (!this.client.isConnected()) {
            this.client.close();
            throw new Exception("The client is not connected.");
        }
        for (Map<String, Object> sm : this.subMaps) {
            this.client.unsubscribe(this.channel, sm);
        }
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public Command clone() {
        return new RemoveSubCommand(this.channel, this.subMaps);
    }

    public String toString() {
        return "remove[]";
    }

    public int hashCode() {
        return HashHelper.hashAddRemoveCommand(this.subMaps);
    }

    public boolean equals(Object obj) {
        return obj.hashCode() == this.hashCode();
    }
}

