/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.commands.commandparsers;

import com.dxfeed.wspt.common.commands.ChannelRequestCommand;
import com.dxfeed.wspt.common.commands.Command;
import com.dxfeed.wspt.common.commands.commandparsers.CommandParser;
import com.dxfeed.wspt.common.constants.SERVICETYPE;
import java.util.HashMap;
import java.util.Map;

public class ChannelRequestCommandParser
implements CommandParser {
    private final Map<String, String> scriptMap;

    public ChannelRequestCommandParser(Map<String, String> scriptMap) {
        this.scriptMap = scriptMap;
    }

    @Override
    public Command parser(String command) {
        SERVICETYPE service = SERVICETYPE.FEED;
        int channel = 1;
        String domSymbol = null;
        String[] domSources = null;
        HashMap<String, Map> chartIndicator = new HashMap<String, Map>();
        if (command.length() >= 15) {
            String[] params;
            for (String param : params = command.substring(15, command.length() - 1).split("]\\[")) {
                String[] keyValue = param.split("=", 2);
                if (keyValue.length != 2) continue;
                if ("service".equals(keyValue[0])) {
                    if ("DOM".equals(keyValue[1])) {
                        service = SERVICETYPE.DOM;
                        continue;
                    }
                    if (!"INDICHART".equals(keyValue[1])) continue;
                    service = SERVICETYPE.INDICHART;
                    continue;
                }
                if ("channel".equals(keyValue[0])) {
                    channel = Integer.parseInt(keyValue[1]);
                    continue;
                }
                if ("symbol".equals(keyValue[0])) {
                    domSymbol = keyValue[1];
                    continue;
                }
                if ("sources".equals(keyValue[0])) {
                    domSources = keyValue[1].split(", ");
                    continue;
                }
                if (!"indicator".equals(keyValue[0])) continue;
                String[] indiSet = keyValue[1].split(", ");
                String indiName = "";
                for (String indi : indiSet) {
                    if (indi.contains("name:")) {
                        indiName = indi.substring(5);
                        chartIndicator.put(indi.substring(5), new HashMap());
                        continue;
                    }
                    if (indi.contains("lang:")) {
                        if (indiName.isEmpty()) continue;
                        ((Map)chartIndicator.get(indiName)).put("lang", indi.substring(5));
                        continue;
                    }
                    if (!indi.contains("content:") || indiName.isEmpty()) continue;
                    String content = indi.substring(8);
                    for (String key : this.scriptMap.keySet()) {
                        content = content.replace("<script>" + key + "</script>", this.scriptMap.get(key));
                    }
                    ((Map)chartIndicator.get(indiName)).put("content", content);
                }
            }
        }
        return new ChannelRequestCommand(service, channel, domSymbol, domSources, chartIndicator);
    }
}

