/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.commands;

import com.devexperts.logging.Logging;
import com.dxfeed.wspt.common.commands.Command;

public class ConnectCommand
extends Command {
    private static final Logging log = Logging.getLogging(ConnectCommand.class);
    private final String user;
    private final int numberUsers;
    private final String connectionId;
    private final String orgConnectionId;
    private final int eventLimit;
    private final long inMiliseconds;
    private String token;

    public ConnectCommand(int numberUsers, String orgConnectionId, String connectionId, String token, String user, int eventLimit, long inMiliseconds) {
        this.numberUsers = numberUsers;
        this.connectionId = connectionId;
        this.orgConnectionId = orgConnectionId;
        this.token = token;
        this.user = user;
        this.eventLimit = eventLimit;
        this.inMiliseconds = inMiliseconds;
    }

    @Override
    public void execute() throws Exception {
        log.info("connect[connectionId=" + this.getConnectionId() + "][token=" + this.token + "][userId=" + this.user + "] - execute.");
        this.client.setConnectionId(this.getConnectionId());
        this.client.connect(this.token);
    }

    public int getNumberUsers() {
        return this.numberUsers;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getOrgConnectionId() {
        return this.orgConnectionId;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String value) {
        this.token = value;
    }

    public String getUser() {
        return this.user;
    }

    public int getEventLimit() {
        return this.eventLimit;
    }

    public long getInMiliseconds() {
        return this.inMiliseconds;
    }

    @Override
    public Command clone() {
        return new ConnectCommand(this.numberUsers, this.orgConnectionId, this.connectionId, this.token, this.user, this.eventLimit, this.inMiliseconds);
    }

    public String toString() {
        return "connect[user=x" + this.numberUsers + "][in=" + this.inMiliseconds + "][connectionId=" + this.connectionId + "][userId=" + this.user + "]";
    }
}

