/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.commands;

import com.devexperts.logging.Logging;
import com.dxfeed.wspt.common.commands.Command;

public class DelayCommand
extends Command {
    private static final Logging log = Logging.getLogging(DelayCommand.class);
    private long duration;

    public DelayCommand(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    @Override
    public void execute() throws Exception {
        log.info("[" + this.client.getConnectionId() + "] - execute. Duration: " + this.duration);
        while (this.duration > 0L) {
            if (!this.client.isConnected()) {
                this.client.close();
                throw new Exception("The client is not connected.");
            }
            Thread.sleep(this.duration > 1000L ? 1000L : this.duration);
            this.duration -= 1000L;
        }
    }

    @Override
    public Command clone() {
        return new DelayCommand(this.duration);
    }

    public String toString() {
        return "delay[" + this.duration / 3600000L + ":" + this.duration / 60000L % 60L + ":" + this.duration / 1000L % 60L + ":" + this.duration % 1000L + "]";
    }
}

