/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.wspt.common.utils;

import com.devexperts.logging.Logging;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeHelper {
    private static final Logging log = Logging.getLogging(TypeHelper.class);

    public static Map<String, Object> parseSub(String command) {
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        subMap.put("subList", new ArrayList());
        List symbolList = (List)subMap.get("subList");
        String[] subs = command.split(", ");
        HashMap<String, Long> prevSub = new HashMap<String, Long>();
        for (String sub : subs) {
            if (sub.isEmpty()) continue;
            if (sub.contains("fromTime=")) {
                prevSub.put("fromTime", Long.parseLong(sub.substring(9)));
                continue;
            }
            HashMap<String, String> symbolDesc = new HashMap<String, String>();
            int idx = sub.indexOf("{");
            String type = sub.substring(0, idx);
            String symbol = sub.substring(idx + 1, sub.length() - 1);
            symbolDesc.put("type", type);
            symbolDesc.put("symbol", symbol);
            symbolList.add(symbolDesc);
            prevSub = symbolDesc;
        }
        return subMap;
    }

    public static Map<String, Object> addSubMapKeyByIdf(String type, String ipfPath) {
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        subMap.put("subList", new ArrayList());
        List symbolList = (List)subMap.get("subList");
        try (BufferedReader br = Files.newBufferedReader(Paths.get(ipfPath, new String[0]));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.charAt(0) == '#') continue;
                int fstIdx = line.indexOf(44);
                int sndIdx = line.indexOf(44, fstIdx + 1);
                String symbol = line.substring(fstIdx + 1, sndIdx);
                HashMap<String, String> symbolDesc = new HashMap<String, String>();
                symbolDesc.put("type", type);
                symbolDesc.put("symbol", symbol);
                symbolList.add(symbolDesc);
            }
        }
        catch (NoSuchFileException e) {
            log.warn("There is no idf file in this path: " + ipfPath);
        }
        catch (IOException e) {
            log.warn("There is an io exception with idf file : ", (Throwable)e);
        }
        return subMap;
    }

    public static Map<String, Object>[] breakDownSubmap(Map<String, Object> subMap, int maxNumSymbols) {
        int totalSymbols = ((List)subMap.get("subList")).size();
        if (maxNumSymbols > 0 && totalSymbols > maxNumSymbols) {
            Map[] brkDwnSubMap = new Map[(int)Math.ceil((double)totalSymbols / (double)maxNumSymbols)];
            int c2 = 0;
            HashMap brkSubMap = null;
            for (int c1 = 0; c1 < totalSymbols; ++c1) {
                Object symbol = ((List)subMap.get("subList")).get(c1);
                if (c1 % maxNumSymbols == 0) {
                    brkSubMap = new HashMap();
                    brkSubMap.put("subList", new ArrayList());
                    brkDwnSubMap[c2] = brkSubMap;
                    ++c2;
                }
                ((List)brkSubMap.get("subList")).add(symbol);
            }
            return brkDwnSubMap;
        }
        return new Map[]{subMap};
    }
}

