/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars2micrometer.marsadapter;

import com.devexperts.mars2micrometer.marsadapter.MarsMetricsFilter;
import com.devexperts.mars2micrometer.marsadapter.MarsNodeMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PrefixesMetricsFilter
implements MarsMetricsFilter {
    private final List<String> configuredPrefixes = new ArrayList<String>();
    private final boolean acceptMatching;

    private PrefixesMetricsFilter(String marsRootNodeName, Collection<String> prefixes, boolean acceptMatching) {
        prefixes.forEach(prefix -> this.configuredPrefixes.add(marsRootNodeName + "." + prefix));
        this.acceptMatching = acceptMatching;
    }

    public static PrefixesMetricsFilter whitelistFilter(String marsRootName, Collection<String> prefixes) {
        return new PrefixesMetricsFilter(marsRootName, prefixes, true);
    }

    public static PrefixesMetricsFilter blacklistFilter(String marsRootName, Collection<String> prefixes) {
        return new PrefixesMetricsFilter(marsRootName, prefixes, false);
    }

    @Override
    public boolean test(MarsNodeMeta nodeMeta) {
        if (this.configuredPrefixes.isEmpty()) {
            return true;
        }
        for (String configuredPrefix : this.configuredPrefixes) {
            if (!nodeMeta.getName().startsWith(configuredPrefix)) continue;
            return this.acceptMatching;
        }
        return !this.acceptMatching;
    }
}

