/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars2micrometer.marsadapter;

import com.devexperts.mars.common.MARSAgent;
import com.devexperts.mars.common.MARSEvent;
import com.devexperts.mars.common.MARSListener;
import com.devexperts.mars2micrometer.marsadapter.MarsNodeMeta;
import com.devexperts.mars2micrometer.marsadapter.ResolvedMarsNodesListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MarsNodesRegistry
implements MARSListener {
    private final List<ResolvedMarsNodesListener> listeners;
    private final Map<String, MarsNodeMeta> resolved = new ConcurrentHashMap<String, MarsNodeMeta>();
    private final Map<String, MarsNodeMeta> unresolved = new ConcurrentHashMap<String, MarsNodeMeta>();

    public MarsNodesRegistry(Collection<ResolvedMarsNodesListener> listeners) {
        this.listeners = listeners == null || listeners.isEmpty() ? new ArrayList<ResolvedMarsNodesListener>() : new ArrayList<ResolvedMarsNodesListener>(listeners);
    }

    public void marsChanged(MARSAgent agent) {
        Collection events = agent.retrieveEvents();
        events.forEach(this::processEvent);
    }

    private void processEvent(MARSEvent event) {
        String nodeName = event.getNodeName();
        if (!this.resolved.containsKey(nodeName)) {
            MarsNodeMeta meta = this.unresolved.computeIfAbsent(nodeName, MarsNodeMeta::new);
            if (event.isValueEvent()) {
                meta.setFirstSeenValue(event.getValue());
            }
            if (event.isDescriptionEvent()) {
                meta.setDescription(event.getValue());
            }
            if (meta.isResolved() && this.resolved.put(nodeName, meta) == null) {
                this.listeners.forEach(listener -> listener.marsNodeResolved(meta));
            }
        }
    }
}

