/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars2micrometer.marsadapter;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MarsToMicrometerNameConverter {
    private static final Pattern COMPONENT_STARTUP_TIME_PATTERN = Pattern.compile("\\d{6}-\\d{6}:\\d{3}\\.");
    private final String marsRoot;
    private final boolean includeMarsRoot;

    public MarsToMicrometerNameConverter(String marsRoot, boolean includeMarsRoot) {
        Objects.requireNonNull(marsRoot, "marsRoot must not be null");
        this.marsRoot = marsRoot;
        this.includeMarsRoot = includeMarsRoot;
    }

    private static String removeMarsRoot(String nodeName, String marsRoot) {
        Objects.requireNonNull(nodeName, "nodeName is null");
        Objects.requireNonNull(marsRoot, "marsRoot is null");
        return nodeName.length() < marsRoot.length() + 1 ? nodeName : nodeName.substring(marsRoot.length() + 1);
    }

    private static String removeStartupTime(String nodeName) {
        Objects.requireNonNull(nodeName, "nodeName is null");
        Matcher m = COMPONENT_STARTUP_TIME_PATTERN.matcher(nodeName);
        if (m.find()) {
            nodeName = m.replaceFirst("");
        }
        return nodeName;
    }

    private static String sanitize(String nodeName) {
        Objects.requireNonNull(nodeName, "nodeName is null");
        return nodeName.replaceAll("\\s+", "-");
    }

    public String convert(String marsNodeName) {
        Objects.requireNonNull(marsNodeName, "marsNodeName is null");
        marsNodeName = this.includeMarsRoot ? MarsToMicrometerNameConverter.removeStartupTime(marsNodeName) : MarsToMicrometerNameConverter.removeMarsRoot(marsNodeName, this.marsRoot);
        return MarsToMicrometerNameConverter.sanitize(marsNodeName);
    }
}

