/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars2micrometer.marsadapter;

import com.devexperts.logging.Logging;
import com.devexperts.mars.common.MARS;
import com.devexperts.mars.common.MARSNode;
import com.devexperts.mars2micrometer.marsadapter.MarsMetricsFilter;
import com.devexperts.mars2micrometer.marsadapter.MarsNodeMeta;
import com.devexperts.mars2micrometer.marsadapter.MarsToMicrometerNameConverter;
import com.devexperts.mars2micrometer.marsadapter.ResolvedMarsNodesListener;
import com.devexperts.mars2micrometer.marsadapter.config.MarsMetricsFilterParser;
import com.devexperts.mars2micrometer.marsadapter.config.MicrometerMarsMetricsExporterProperties;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class MicrometerMarsMetricsExporter
implements ResolvedMarsNodesListener {
    private static final Logging log = Logging.getLogging(MicrometerMarsMetricsExporter.class);
    private final MARS mars;
    private final MeterRegistry meterRegistry;
    private final MarsMetricsFilter metricsFilter;
    private final MarsToMicrometerNameConverter metricNameConverter;
    private final int maxAllowedFailures;

    private MicrometerMarsMetricsExporter(Builder builder) {
        this.mars = builder.mars;
        this.meterRegistry = builder.meterRegistry;
        this.metricsFilter = builder.metricsFilter;
        this.metricNameConverter = new MarsToMicrometerNameConverter(builder.marsRoot.getName(), builder.includeMarsRoot);
        this.maxAllowedFailures = builder.maxAllowedFailures;
    }

    @Override
    public void marsNodeResolved(MarsNodeMeta nodeMeta) {
        assert (nodeMeta != null) : "nodeMeta must not be null";
        if (!this.metricsFilter.test(nodeMeta)) {
            if (log.debugEnabled()) {
                log.debug("Filtered out MARS metric, marsNodeName=" + nodeMeta.getName());
            }
            return;
        }
        try {
            Gauge gauge = Gauge.builder((String)this.metricNameConverter.convert(nodeMeta.getName()), (Supplier)new MetricValueSupplier(nodeMeta)).description(nodeMeta.getDescription()).register(this.meterRegistry);
            log.info(String.format("Registered Gauge, marsNodeName=%s, gaugeName=%s", nodeMeta.getName(), gauge.getId().getName()));
        }
        catch (IllegalArgumentException e) {
            log.warn("Failed to register Gauge, marsNodeName=" + nodeMeta.getName(), (Throwable)e);
        }
    }

    private class MetricValueSupplier
    implements Supplier<Number> {
        private final MarsNodeMeta nodeMeta;
        private final AtomicInteger failureCounter = new AtomicInteger(0);

        public MetricValueSupplier(MarsNodeMeta nodeMeta) {
            this.nodeMeta = nodeMeta;
        }

        @Override
        public Number get() {
            if (this.failureCounter.get() > MicrometerMarsMetricsExporter.this.maxAllowedFailures) {
                return Double.NaN;
            }
            try {
                return Double.parseDouble(MicrometerMarsMetricsExporter.this.mars.getValue(this.nodeMeta.getMarsValueNode()));
            }
            catch (NumberFormatException e) {
                if (this.failureCounter.incrementAndGet() > MicrometerMarsMetricsExporter.this.maxAllowedFailures) {
                    log.warn("Too many failures to parse MARS metric value - switching to NaN, marsNodeName=" + this.nodeMeta.getName());
                }
                return Double.NaN;
            }
        }
    }

    public static class Builder {
        private static final int DEFAULT_MAX_FAILURES_THRESHOLD = 10;
        private final MARS mars;
        private final MARSNode marsRoot;
        private final MeterRegistry meterRegistry;
        private MarsMetricsFilter metricsFilter;
        private boolean includeMarsRoot = true;
        private int maxAllowedFailures = 10;

        public Builder(MARSNode marsRoot, MeterRegistry meterRegistry) {
            this.mars = marsRoot.getMars();
            this.marsRoot = marsRoot;
            this.meterRegistry = meterRegistry;
        }

        public Builder properties(MicrometerMarsMetricsExporterProperties properties) {
            this.metricsFilter(properties.getPrefixesFilter());
            this.includeMarsRoot(properties.isIncludeMarsRoot());
            return this;
        }

        public Builder metricsFilter(MarsMetricsFilter metricsFilter) {
            this.metricsFilter = metricsFilter;
            return this;
        }

        public Builder metricsFilter(String metricsFilter) {
            this.metricsFilter = MarsMetricsFilterParser.parseFilter(this.marsRoot.getName(), metricsFilter);
            return this;
        }

        public Builder includeMarsRoot(boolean includeMarsRoot) {
            this.includeMarsRoot = includeMarsRoot;
            return this;
        }

        public Builder setMaxAllowedFailures(int maxAllowedFailures) {
            this.maxAllowedFailures = maxAllowedFailures;
            return this;
        }

        public MicrometerMarsMetricsExporter build() {
            Objects.requireNonNull(this.metricsFilter);
            if (this.maxAllowedFailures < 0) {
                throw new IllegalArgumentException("maxAllowedFailures must be a positive number");
            }
            return new MicrometerMarsMetricsExporter(this);
        }
    }
}

