/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars2micrometer.marsplugin;

import com.devexperts.mars2micrometer.marsplugin.BuiltInPrometheusMeters;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmCompilationMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.Log4j2Metrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;

public class BuiltInPrometheusMetersFactory {
    public MeterBinder createMeter(BuiltInPrometheusMeters meter) {
        switch (meter) {
            case PROCESSOR: {
                return new ProcessorMetrics();
            }
            case FILEDESCRIPTOR: {
                return new FileDescriptorMetrics();
            }
            case UPTIME: {
                return new UptimeMetrics();
            }
            case CLASSLOADER: {
                return new ClassLoaderMetrics();
            }
            case JVMTHREAD: {
                return new JvmThreadMetrics();
            }
            case JVMCOMPILATION: {
                return new JvmCompilationMetrics();
            }
            case JVMMEMORY: {
                return new JvmMemoryMetrics();
            }
            case JVMHEAPPRESSURE: {
                return new JvmHeapPressureMetrics();
            }
            case JVMGC: {
                return new JvmGcMetrics();
            }
            case LOG4J2: {
                return new Log4j2Metrics();
            }
        }
        throw new IllegalArgumentException("Unknown meter: " + (Object)((Object)meter));
    }
}

