/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars2micrometer.marsplugin;

import com.devexperts.mars.common.MARSEndpoint;
import com.devexperts.mars2micrometer.marsplugin.MarsToPrometheusPluginProperties;
import com.devexperts.mars2micrometer.marsplugin.MarsToPrometheusPluginPropertiesProvider;
import java.util.Properties;

class JavaSysPropsPluginPropertiesProvider
implements MarsToPrometheusPluginPropertiesProvider {
    private static final String PLUGIN_ENABLED = "mars2prometheus.enabled";
    private static final String METRICS_FILTER = "mars2prometheus.filter";
    private static final String INCLUDE_MARS_ROOT = "mars2prometheus.includeMarsRoot";
    private static final String BUILT_IN_PROMETHEUS_METERS = "mars2prometheus.builtInPrometheusMeters";
    private static final String SERVER_HOSTNAME = "mars2prometheus.server.hostname";
    private static final String SERVER_PORT = "mars2prometheus.server.port";

    JavaSysPropsPluginPropertiesProvider() {
    }

    @Override
    public MarsToPrometheusPluginProperties loadPluginProperties(MARSEndpoint marsEndpoint) {
        assert (marsEndpoint != null) : "marsEndpoint must not be null";
        MarsToPrometheusPluginProperties.Builder builder = new MarsToPrometheusPluginProperties.Builder();
        Properties sysProps = System.getProperties();
        if (sysProps.containsKey(PLUGIN_ENABLED)) {
            builder.setPluginEnabled(Boolean.parseBoolean(sysProps.getProperty(PLUGIN_ENABLED)));
        }
        if (sysProps.containsKey(METRICS_FILTER)) {
            builder.setPrefixesFilter(sysProps.getProperty(METRICS_FILTER));
        }
        if (sysProps.containsKey(INCLUDE_MARS_ROOT)) {
            builder.setIncludeMarsRoot(Boolean.parseBoolean(sysProps.getProperty(INCLUDE_MARS_ROOT)));
        }
        if (sysProps.containsKey(BUILT_IN_PROMETHEUS_METERS)) {
            builder.setBuiltInPrometheusMeters(sysProps.getProperty(BUILT_IN_PROMETHEUS_METERS));
        }
        if (sysProps.containsKey(SERVER_HOSTNAME)) {
            builder.setPrometheusEndpointHostname(sysProps.getProperty(SERVER_HOSTNAME));
        }
        if (sysProps.containsKey(SERVER_PORT)) {
            builder.setPrometheusEndpointPort(Integer.parseInt(sysProps.getProperty(SERVER_PORT)));
        }
        return builder.build();
    }
}

