/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.mars2micrometer.marsplugin;

import com.devexperts.logging.Logging;
import com.devexperts.mars.common.MARS;
import com.devexperts.mars.common.MARSAgent;
import com.devexperts.mars.common.MARSEndpoint;
import com.devexperts.mars.common.MARSListener;
import com.devexperts.mars.common.MARSPlugin;
import com.devexperts.mars2micrometer.marsadapter.MarsNodesRegistry;
import com.devexperts.mars2micrometer.marsadapter.MicrometerMarsMetricsExporter;
import com.devexperts.mars2micrometer.marsplugin.BuiltInPrometheusMeters;
import com.devexperts.mars2micrometer.marsplugin.BuiltInPrometheusMetersFactory;
import com.devexperts.mars2micrometer.marsplugin.DisabledMarsToPrometheusPlugin;
import com.devexperts.mars2micrometer.marsplugin.EnabledMarsToPrometheusPlugin;
import com.devexperts.mars2micrometer.marsplugin.JavaSysPropsPluginPropertiesProvider;
import com.devexperts.mars2micrometer.marsplugin.MarsToPrometheusPluginProperties;
import com.devexperts.mars2micrometer.marsplugin.MarsToPrometheusPluginPropertiesProvider;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.util.Collections;

public class MarsToPrometheusPluginFactory
extends MARSPlugin.Factory {
    private static final Logging log = Logging.getLogging(MarsToPrometheusPluginFactory.class);
    private final MarsToPrometheusPluginPropertiesProvider propsProvider;
    private final PrometheusMeterRegistry meterRegistry;

    public MarsToPrometheusPluginFactory() {
        this(new JavaSysPropsPluginPropertiesProvider(), new PrometheusMeterRegistry(PrometheusConfig.DEFAULT));
    }

    public MarsToPrometheusPluginFactory(MarsToPrometheusPluginPropertiesProvider propsProvider, PrometheusMeterRegistry meterRegistry) {
        this.propsProvider = propsProvider;
        this.meterRegistry = meterRegistry;
    }

    public MARSPlugin createPlugin(MARSEndpoint marsEndpoint) {
        HTTPServer prometheusServer;
        MarsToPrometheusPluginProperties props = this.propsProvider.loadPluginProperties(marsEndpoint);
        if (!props.isPluginEnabled()) {
            log.info("MARS to Prometheus Plugin is disabled");
            return DisabledMarsToPrometheusPlugin.INSTANCE;
        }
        MARS mars = marsEndpoint.getRoot().getMars();
        MicrometerMarsMetricsExporter metricsExporter = new MicrometerMarsMetricsExporter.Builder(marsEndpoint.getRoot(), (MeterRegistry)this.meterRegistry).properties(props.getMetricsExporterProperties()).build();
        MarsNodesRegistry marsNodesRegistry = new MarsNodesRegistry(Collections.singletonList(metricsExporter));
        MARSAgent marsAgent = new MARSAgent(mars);
        marsAgent.setListener((MARSListener)marsNodesRegistry);
        BuiltInPrometheusMetersFactory builtInPrometheusMetersFactory = new BuiltInPrometheusMetersFactory();
        props.getBuiltInPrometheusMetersProperties().getSupportedMarsTypes().forEach(m -> builtInPrometheusMetersFactory.createMeter((BuiltInPrometheusMeters)((Object)m)).bindTo((MeterRegistry)this.meterRegistry));
        log.info("Configured MARS metrics exporter, exporterProperties=" + props.getMetricsExporterProperties());
        try {
            prometheusServer = new HTTPServer.Builder().withRegistry(this.meterRegistry.getPrometheusRegistry()).withHostname(props.getPrometheusEndpointHostname()).withPort(props.getPrometheusEndpointPort()).withDaemonThreads(true).build();
        }
        catch (IOException e) {
            log.error("Failed to configure Prometheus HTTP server, disabling the plugin", (Throwable)e);
            return DisabledMarsToPrometheusPlugin.INSTANCE;
        }
        log.info(String.format("Configured Prometheus HTTP server, host=%s, port=%s", props.getPrometheusEndpointHostname(), props.getPrometheusEndpointPort()));
        return new EnabledMarsToPrometheusPlugin(marsAgent, this.meterRegistry, prometheusServer);
    }
}

